/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.spectre;

import cpw.mods.fml.common.FMLCommonHandler;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.drive.TileEntityCarriageTranslocator;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.spectre.TeleportativeSpectreTeleporter;
import me.planetguy.remaininmotion.spectre.TileEntityMotiveSpectre;
import me.planetguy.remaininmotion.util.WorldUtil;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityTeleportativeSpectre
extends TileEntityMotiveSpectre {
    public boolean Source;
    public int ShiftX;
    public int ShiftY;
    public int ShiftZ;
    public int MinX;
    public int MinY;
    public int MinZ;
    public int MaxX;
    public int MaxY;
    public int MaxZ;
    public int TargetDimension;

    @Override
    public void WriteCommonRecord(NBTTagCompound TagCompound) {
        super.WriteCommonRecord(TagCompound);
        TagCompound.func_74757_a("Source", this.Source);
        TagCompound.func_74768_a("ShiftX", this.ShiftX);
        TagCompound.func_74768_a("ShiftY", this.ShiftY);
        TagCompound.func_74768_a("ShiftZ", this.ShiftZ);
        TagCompound.func_74768_a("MinX", this.MinX);
        TagCompound.func_74768_a("MinY", this.MinY);
        TagCompound.func_74768_a("MinZ", this.MinZ);
        TagCompound.func_74768_a("MaxX", this.MaxX);
        TagCompound.func_74768_a("MaxY", this.MaxY);
        TagCompound.func_74768_a("MaxZ", this.MaxZ);
        TagCompound.func_74768_a("TargetDimension", this.TargetDimension);
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound TagCompound) {
        super.ReadCommonRecord(TagCompound);
        this.Source = TagCompound.func_74767_n("Source");
        this.ShiftX = TagCompound.func_74762_e("ShiftX");
        this.ShiftY = TagCompound.func_74762_e("ShiftY");
        this.ShiftZ = TagCompound.func_74762_e("ShiftZ");
        this.MinX = TagCompound.func_74762_e("MinX");
        this.MinY = TagCompound.func_74762_e("MinY");
        this.MinZ = TagCompound.func_74762_e("MinZ");
        this.MaxX = TagCompound.func_74762_e("MaxX");
        this.MaxY = TagCompound.func_74762_e("MaxY");
        this.MaxZ = TagCompound.func_74762_e("MaxZ");
        this.TargetDimension = TagCompound.func_74762_e("TargetDimension");
    }

    public void AbsorbCommon(CarriagePackage Package) {
        this.ShiftX = -Package.driveRecord.X + Package.Translocator.field_145851_c;
        this.ShiftY = -Package.driveRecord.Y + Package.Translocator.field_145848_d;
        this.ShiftZ = -Package.driveRecord.Z + Package.Translocator.field_145849_e;
        this.MinX = Package.MinX;
        this.MinY = Package.MinY;
        this.MinZ = Package.MinZ;
        this.MaxX = Package.MaxX;
        this.MaxY = Package.MaxY;
        this.MaxZ = Package.MaxZ;
        this.TargetDimension = Package.Translocator.func_145831_w().field_73011_w.field_76574_g;
        this.motionDirection = Directions.values()[0];
    }

    public void AbsorbSource(CarriagePackage Package) {
        this.AbsorbCommon(Package);
        this.Source = true;
        this.renderCacheKey = Package.RenderCacheKey;
        this.driveRecord = new BlockRecord(Package.driveRecord);
        this.body = new BlockRecordSet();
        for (BlockRecord Record : Package.Body) {
            this.body.add(new BlockRecord(Record));
        }
        this.pendingBlockUpdates = new NBTTagList();
    }

    public void AbsorbSink(CarriagePackage Package) {
        this.Absorb(Package);
        this.AbsorbCommon(Package);
        this.driveRecord = new BlockRecord(Package.Translocator.field_145851_c, Package.Translocator.field_145848_d, Package.Translocator.field_145849_e);
    }

    @Override
    public void ShiftBlockPosition(BlockRecord Record) {
        Record.X += this.ShiftX;
        Record.Y += this.ShiftY;
        Record.Z += this.ShiftZ;
    }

    @Override
    public void ScheduleShiftedBlockUpdate(NBTTagCompound PendingBlockUpdateRecord) {
        this.field_145850_b.func_147446_b(PendingBlockUpdateRecord.func_74762_e("X") + this.ShiftX, PendingBlockUpdateRecord.func_74762_e("Y") + this.ShiftY, PendingBlockUpdateRecord.func_74762_e("Z") + this.ShiftZ, Block.func_149729_e((int)PendingBlockUpdateRecord.func_74762_e("Id")), PendingBlockUpdateRecord.func_74762_e("Delay"), PendingBlockUpdateRecord.func_74762_e("Priority"));
    }

    @Override
    public void func_145845_h() {
        ++this.ticksExisted;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.ticksExisted < this.getTeleportDuration()) {
            return;
        }
        if (this.Source) {
            try {
                ((TileEntityCarriageTranslocator)this.field_145850_b.func_147438_o(this.driveRecord.X, this.driveRecord.Y, this.driveRecord.Z)).ToggleActivity();
            }
            catch (Throwable Throwable2) {
                Throwable2.printStackTrace();
            }
            for (BlockRecord Record : this.body) {
                WorldUtil.ClearBlock(this.field_145850_b, Record.X, Record.Y, Record.Z);
            }
            this.CaptureEntities(this.MinX, this.MinY, this.MinZ, this.MaxX, this.MaxY, this.MaxZ);
            return;
        }
        this.Release();
    }

    public int getTeleportDuration() {
        return RiMConfiguration.CarriageMotion.TeleportationDuration;
    }

    @Override
    public boolean ShouldCaptureEntity(Entity Entity2) {
        if (!RiMConfiguration.CarriageMotion.TeleportEntities) {
            return false;
        }
        return super.ShouldCaptureEntity(Entity2);
    }

    @Override
    public void ProcessCapturedEntity(Entity Entity2) {
        if (Entity2.field_70153_n == null) {
            this.TeleportEntity(Entity2);
        }
    }

    public Entity TeleportEntity(Entity entity) {
        MinecraftServer Server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer HomeWorld = (WorldServer)this.field_145850_b;
        WorldServer TargetWorld = Server.func_71218_a(this.TargetDimension);
        TeleportativeSpectreTeleporter Teleporter2 = new TeleportativeSpectreTeleporter(this.field_145850_b);
        boolean Transdimensional = HomeWorld.field_73011_w.field_76574_g != TargetWorld.field_73011_w.field_76574_g;
        double X = entity.field_70165_t + (double)this.ShiftX;
        double Y = entity.field_70163_u + (double)this.ShiftY;
        double Z = entity.field_70161_v + (double)this.ShiftZ;
        float Yaw = entity.field_70177_z;
        float Pitch = entity.field_70125_A;
        Entity Mount = entity.field_70154_o;
        if (Mount != null) {
            entity.func_70078_a(null);
            Mount = this.TeleportEntity(Mount);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP Player = (EntityPlayerMP)entity;
            if (Transdimensional) {
                int dimension = Player.field_71093_bK;
                Server.func_71203_ab().transferPlayerToDimension(Player, this.TargetDimension, (Teleporter)Teleporter2);
                if (dimension == 1) {
                    TargetWorld.func_72838_d((Entity)Player);
                }
            }
            Player.field_71135_a.func_147364_a(X, Y, Z, Yaw, Pitch);
            Player.func_70012_b(X, Y, Z, Yaw, Pitch);
        } else if (Transdimensional) {
            entity.field_71093_bK = this.TargetDimension;
            HomeWorld.func_72900_e(entity);
            entity.field_70128_L = false;
            Server.func_71203_ab().func_82448_a(entity, this.TargetDimension, HomeWorld, TargetWorld);
            Entity newEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)TargetWorld);
            newEntity.func_82141_a(entity, true);
            newEntity.func_70012_b(X, Y, Z, Yaw, Pitch);
            TargetWorld.func_72838_d(newEntity);
            entity.field_70128_L = true;
            HomeWorld.func_82742_i();
            TargetWorld.func_82742_i();
            entity = newEntity;
        } else {
            entity.func_70012_b(X, Y, Z, Yaw, Pitch);
            TargetWorld.func_72866_a(entity, false);
        }
        if (Mount != null) {
            entity.func_70078_a(Mount);
        }
        return entity;
    }

    @Override
    public int[] getOffset() {
        return new int[]{this.ShiftX, this.ShiftY, this.ShiftZ};
    }
}

