/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.spectre;

import me.planetguy.remaininmotion.core.interop.EventPool;
import me.planetguy.remaininmotion.spectre.RemIMRotator;
import me.planetguy.remaininmotion.spectre.TileEntityMotiveSpectre;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.transformations.Directions;
import me.planetguy.remaininmotion.util.transformations.Matrix;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRotativeSpectre
extends TileEntityMotiveSpectre {
    private int axisOfRotation;

    public TileEntityRotativeSpectre() {
        this.motionDirection = Directions.Null;
        this.axisOfRotation = Directions.PosY.ordinal();
    }

    @Override
    public void ShiftBlockPosition(BlockRecord record) {
        RemIMRotator.rotateOrthogonal(this.driveRecord, Directions.values()[this.axisOfRotation], record);
    }

    @Override
    public int[] getOffset(BlockRecord record) {
        BlockRecord out = RemIMRotator.simulateRotateOrthogonal(this.driveRecord, Directions.values()[this.axisOfRotation], record);
        return new int[]{out.X, out.Y, out.Z};
    }

    @Override
    public void onMotionFinalized(BlockRecord record) {
        Block b = this.field_145850_b.func_147439_a(record.X, record.Y, record.Z);
        if (!this.field_145850_b.field_72995_K) {
            b.rotateBlock(this.field_145850_b, record.X, record.Y, record.Z, ForgeDirection.values()[this.axisOfRotation]);
            EventPool.postBlockRotateEvent(record, ForgeDirection.values()[this.axisOfRotation]);
        }
    }

    @Override
    public void announceTEConstruction(BlockRecord record) {
        EventPool.postRotatingTEPreUnpackEvent(this, record, ForgeDirection.getOrientation((int)this.axisOfRotation));
    }

    @Override
    public void doPerSpectreEntityUpdate(TileEntityMotiveSpectre.CapturedEntity capture, Entity entity) {
        if (capture.startingPosition == null) {
            capture.startingPosition = new Matrix(new double[][]{{entity.field_70165_t}, {entity.field_70163_u - (double)(2.0f * entity.func_70047_e())}, {entity.field_70161_v}});
        }
        Matrix newPos = new Matrix(Matrix.copy(capture.startingPosition.matrix));
        double fractionOfCircle = 0.2617993877991494 * Math.min((double)this.ticksExisted / (double)this.personalDurationInTicks, 1.0);
        if (this.driveRecord != null) {
            RemIMRotator.rotatePartialEntity(this.driveRecord, Directions.values()[this.axisOfRotation], newPos, fractionOfCircle);
        }
        entity.func_70012_b(newPos.matrix[0][0], newPos.matrix[1][0], newPos.matrix[2][0], entity.field_70177_z, entity.field_70125_A);
        entity.field_70143_R = 0.0f;
        if (this.ticksExisted >= this.personalDurationInTicks) {
            capture.stop();
            entity.field_70122_E = capture.WasOnGround;
            entity.field_70160_al = capture.WasAirBorne;
            return;
        }
        capture.stop();
        entity.field_70122_E = false;
        entity.field_70160_al = true;
    }

    public void setAxis(int axis) {
        this.axisOfRotation = axis;
    }

    public int getAxis() {
        return this.axisOfRotation;
    }

    @Override
    public void WriteCommonRecord(NBTTagCompound tag) {
        super.WriteCommonRecord(tag);
        tag.func_74768_a("axisOfRotation", this.axisOfRotation);
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound tag) {
        super.ReadCommonRecord(tag);
        this.axisOfRotation = tag.func_74762_e("axisOfRotation");
    }
}

