/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ITierItem;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBlockGasTank
extends ItemBlock
implements IGasItem,
ISustainedInventory,
ITierItem,
ISecurityItem {
    public Block metaBlock;
    public int MAX_GAS = 96000;
    public static final int TRANSFER_RATE = 256;

    public ItemBlockGasTank(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public IIcon func_77617_a(int i) {
        return this.metaBlock.func_149691_a(2, i);
    }

    public String func_77653_i(ItemStack itemstack) {
        return LangUtils.localize("tile.GasTank" + this.getBaseTier(itemstack).getName() + ".name");
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityGasTank tileEntity = (TileEntityGasTank)world.func_147438_o(x, y, z);
            tileEntity.tier = Tier.GasTankTier.values()[this.getBaseTier(stack).ordinal()];
            tileEntity.gasTank.setMaxGas(tileEntity.tier.storage);
            tileEntity.gasTank.setGas(this.getGas(stack));
            if (tileEntity instanceof ISecurityTile) {
                TileEntityGasTank security = tileEntity;
                security.getSecurity().setOwner(this.getOwner(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwner(stack) == null) {
                    security.getSecurity().setOwner(player.func_70005_c_());
                }
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
        return place;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty") + ".");
        } else {
            list.add((Object)((Object)EnumColor.ORANGE) + gasStack.getGas().getLocalizedName() + ": " + (Object)((Object)EnumColor.GREY) + gasStack.amount);
        }
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + Tier.GasTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].storage);
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        return GasStack.readFromNBT(itemstack.field_77990_d.func_74775_l("stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (stack == null || stack.amount == 0) {
            itemstack.field_77990_d.func_82580_o("stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            itemstack.field_77990_d.func_74782_a("stored", (NBTBase)gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem(Tier.GasTankTier tier) {
        ItemStack empty = new ItemStack((Item)this);
        this.setBaseTier(empty, tier.getBaseTier());
        this.setGas(empty, null);
        return empty;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (Tier.GasTankTier tier : Tier.GasTankTier.values()) {
            ItemStack empty = new ItemStack((Item)this);
            this.setBaseTier(empty, tier.getBaseTier());
            list.add(empty);
        }
        if (MekanismConfig.general.prefilledGasTanks) {
            for (Gas type : GasRegistry.getRegisteredGasses()) {
                if (!type.isVisible()) continue;
                ItemStack filled = new ItemStack((Item)this);
                this.setBaseTier(filled, Tier.BaseTier.ULTIMATE);
                this.setGas(filled, new GasStack(type, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
                list.add(filled);
            }
        }
    }

    @Override
    public Tier.BaseTier getBaseTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.field_77990_d.func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74768_a("tier", tier.ordinal());
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return Tier.GasTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].storage;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return Tier.GasTankTier.values()[this.getBaseTier((ItemStack)itemstack).ordinal()].output;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("owner")) {
            return stack.field_77990_d.func_74779_i("owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (owner == null || owner.isEmpty()) {
            stack.field_77990_d.func_82580_o("owner");
            return;
        }
        stack.field_77990_d.func_74778_a("owner", owner);
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[stack.field_77990_d.func_74762_e("security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

