/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.RenderDynamicTank;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityBoilerCasing;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderThermoelectricBoiler
extends TileEntitySpecialRenderer {
    private static Map<RenderDynamicTank.RenderData, MekanismRenderer.DisplayInteger[]> cachedLowerFluids = new HashMap<RenderDynamicTank.RenderData, MekanismRenderer.DisplayInteger[]>();
    private static Map<RenderDynamicTank.RenderData, MekanismRenderer.DisplayInteger> cachedUpperFluids = new HashMap<RenderDynamicTank.RenderData, MekanismRenderer.DisplayInteger>();
    private static Map<RenderDynamicTank.ValveRenderData, MekanismRenderer.DisplayInteger> cachedValveFluids = new HashMap<RenderDynamicTank.ValveRenderData, MekanismRenderer.DisplayInteger>();
    private Fluid STEAM = FluidRegistry.getFluid((String)"steam");
    private Fluid WATER = FluidRegistry.WATER;

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityBoilerCasing)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityBoilerCasing tileEntity, double x, double y, double z, float partialTick) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && ((SynchronizedBoilerData)tileEntity.structure).renderLocation != null && ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation != null) {
            RenderDynamicTank.RenderData data;
            if (((SynchronizedBoilerData)tileEntity.structure).waterStored != null && ((SynchronizedBoilerData)tileEntity.structure).waterStored.amount != 0) {
                data = new RenderDynamicTank.RenderData();
                data.location = ((SynchronizedBoilerData)tileEntity.structure).renderLocation;
                data.height = ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation.yCoord - 1 - ((SynchronizedBoilerData)tileEntity.structure).renderLocation.yCoord;
                data.length = ((SynchronizedBoilerData)tileEntity.structure).volLength;
                data.width = ((SynchronizedBoilerData)tileEntity.structure).volWidth;
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                if (data.location != null && data.height >= 1 && ((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid() != null) {
                    this.push();
                    GL11.glTranslated((double)this.getX(data.location.xCoord), (double)this.getY(data.location.yCoord), (double)this.getZ(data.location.zCoord));
                    MekanismRenderer.glowOn(((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid().getLuminosity());
                    MekanismRenderer.colorFluid(((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid());
                    MekanismRenderer.DisplayInteger[] displayList = this.getLowerDisplay(data, ((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid(), tileEntity.func_145831_w());
                    if (((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid().isGaseous()) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)((SynchronizedBoilerData)tileEntity.structure).waterStored.amount / (float)tileEntity.clientWaterCapacity + MekanismRenderer.GAS_RENDER_BASE));
                        displayList[this.getStages(data.height) - 1].render();
                    } else {
                        displayList[Math.min(this.getStages(data.height) - 1, (int)(tileEntity.prevWaterScale * ((float)this.getStages(data.height) - 1.0f)))].render();
                    }
                    MekanismRenderer.glowOff();
                    MekanismRenderer.resetColor();
                    this.pop();
                    for (SynchronizedTankData.ValveData valveData : tileEntity.valveViewing) {
                        this.push();
                        GL11.glTranslated((double)this.getX(valveData.location.xCoord), (double)this.getY(valveData.location.yCoord), (double)this.getZ(valveData.location.zCoord));
                        MekanismRenderer.glowOn(((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid().getLuminosity());
                        this.getValveDisplay(RenderDynamicTank.ValveRenderData.get(data, valveData), ((SynchronizedBoilerData)tileEntity.structure).waterStored.getFluid(), tileEntity.func_145831_w()).render();
                        MekanismRenderer.glowOff();
                        MekanismRenderer.resetColor();
                        this.pop();
                    }
                }
            }
            if (((SynchronizedBoilerData)tileEntity.structure).steamStored != null && ((SynchronizedBoilerData)tileEntity.structure).steamStored.amount != 0) {
                data = new RenderDynamicTank.RenderData();
                data.location = ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation;
                data.height = ((SynchronizedBoilerData)tileEntity.structure).renderLocation.yCoord + ((SynchronizedBoilerData)tileEntity.structure).volHeight - 2 - ((SynchronizedBoilerData)tileEntity.structure).upperRenderLocation.yCoord;
                data.length = ((SynchronizedBoilerData)tileEntity.structure).volLength;
                data.width = ((SynchronizedBoilerData)tileEntity.structure).volWidth;
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                if (data.location != null && data.height >= 1 && ((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid() != null) {
                    this.push();
                    GL11.glTranslated((double)this.getX(data.location.xCoord), (double)this.getY(data.location.yCoord), (double)this.getZ(data.location.zCoord));
                    MekanismRenderer.glowOn(((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid().getLuminosity());
                    MekanismRenderer.colorFluid(((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid());
                    MekanismRenderer.DisplayInteger display = this.getUpperDisplay(data, ((SynchronizedBoilerData)tileEntity.structure).steamStored.getFluid(), tileEntity.func_145831_w());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)((SynchronizedBoilerData)tileEntity.structure).steamStored.amount / (float)tileEntity.clientSteamCapacity + MekanismRenderer.GAS_RENDER_BASE));
                    display.render();
                    MekanismRenderer.glowOff();
                    MekanismRenderer.resetColor();
                    this.pop();
                }
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger[] getLowerDisplay(RenderDynamicTank.RenderData data, Fluid fluid, World world) {
        if (cachedLowerFluids.containsKey(data)) {
            return cachedLowerFluids.get(data);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getIcon());
        int stages = this.getStages(data.height);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedLowerFluids.put(data, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getIcon() != null) {
                toReturn.minX = 0.01;
                toReturn.minY = 0.01;
                toReturn.minZ = 0.01;
                toReturn.maxX = (double)data.length - 0.01;
                toReturn.maxY = (double)((float)i / (float)stages * (float)data.height) - 0.01;
                toReturn.maxZ = (double)data.width - 0.01;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger getUpperDisplay(RenderDynamicTank.RenderData data, Fluid fluid, World world) {
        if (cachedUpperFluids.containsKey(data)) {
            return cachedUpperFluids.get(data);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getIcon());
        int stages = this.getStages(data.height);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        cachedUpperFluids.put(data, display);
        if (this.STEAM.getIcon() != null) {
            toReturn.minX = 0.01;
            toReturn.minY = 0.01;
            toReturn.minZ = 0.01;
            toReturn.maxX = (double)data.length - 0.01;
            toReturn.maxY = (double)data.height - 0.01;
            toReturn.maxZ = (double)data.width - 0.01;
            MekanismRenderer.renderObject(toReturn);
        }
        GL11.glEndList();
        return display;
    }

    private MekanismRenderer.DisplayInteger getValveDisplay(RenderDynamicTank.ValveRenderData data, Fluid fluid, World world) {
        if (cachedValveFluids.containsKey(data)) {
            return cachedValveFluids.get(data);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getFlowingIcon());
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        cachedValveFluids.put(data, display);
        switch (data.side) {
            case DOWN: {
                toReturn.minX = 0.3;
                toReturn.minY = 1.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = 1.5;
                toReturn.maxZ = 0.7;
                break;
            }
            case UP: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-(data.height - 2)) - 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 0.7;
                toReturn.maxY = -0.01;
                toReturn.maxZ = 0.7;
                break;
            }
            case NORTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 1.02;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 1.4;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.3;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = -0.4;
                toReturn.maxX = 0.7;
                toReturn.maxY = 0.7;
                toReturn.maxZ = -0.02;
                break;
            }
            case WEST: {
                toReturn.minX = 1.02;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = 1.4;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
            case EAST: {
                toReturn.minX = -0.4;
                toReturn.minY = (double)(-this.getValveFluidHeight(data)) + 0.01;
                toReturn.minZ = 0.3;
                toReturn.maxX = -0.02;
                toReturn.maxY = 0.7;
                toReturn.maxZ = 0.7;
                break;
            }
        }
        if (fluid.getFlowingIcon() != null) {
            MekanismRenderer.renderObject(toReturn);
        }
        display.endList();
        return display;
    }

    private int getValveFluidHeight(RenderDynamicTank.ValveRenderData data) {
        return data.valveLocation.yCoord - data.location.yCoord;
    }

    private int getStages(int height) {
        return height * 1600;
    }

    private double getX(int x) {
        return (double)x - TileEntityRendererDispatcher.field_147554_b;
    }

    private double getY(int y) {
        return (double)y - TileEntityRendererDispatcher.field_147555_c;
    }

    private double getZ(int z) {
        return (double)z - TileEntityRendererDispatcher.field_147552_d;
    }

    public static void resetDisplayInts() {
        cachedLowerFluids.clear();
        cachedUpperFluids.clear();
        cachedValveFluids.clear();
    }
}

