/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openmods.Log;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.reflection.SafeClassLoad;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.EntityUtils;

public class TileEntityTarget
extends SyncedTileEntity
implements ISurfaceAttachment,
INeighbourAwareTile {
    private int strength = 0;
    private int tickCounter = -1;
    private SyncableBoolean active;
    private static final SafeClassLoad FLANS_BULLET = SafeClassLoad.create((String)"com.flansmod.common.guns.EntityBullet");
    public static final Set<Class<?>> EXTRA_PROJECTILE_CLASSES = Sets.newHashSet();
    private static final IEntitySelector PROJECTILE_SELECTOR;

    private static void addClass(SafeClassLoad cls) {
        if (cls.tryLoad()) {
            EXTRA_PROJECTILE_CLASSES.add(cls.get());
        } else {
            Log.info((String)"Failed to load class %s, no target path prediction", (Object[])new Object[]{cls.clsName});
        }
    }

    protected void createSyncedFields() {
        this.active = new SyncableBoolean();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.predictOtherProjectiles();
        }
        --this.tickCounter;
        if (this.tickCounter == 0) {
            this.tickCounter = -1;
            this.strength = 0;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)OpenBlocks.Blocks.target);
        }
    }

    private void predictOtherProjectiles() {
        List projectiles = this.field_145850_b.func_82733_a(Entity.class, this.getBB().func_72314_b(10.0, 10.0, 10.0), PROJECTILE_SELECTOR);
        for (Entity projectile : projectiles) {
            MovingObjectPosition hit = EntityUtils.raytraceEntity((Entity)projectile);
            if (!BlockUtils.isBlockHit((MovingObjectPosition)hit, (TileEntity)this)) continue;
            OpenBlocks.Blocks.target.onTargetHit(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, hit.field_72307_f);
        }
    }

    public void setEnabled(boolean en) {
        this.active.set(en);
    }

    public boolean isEnabled() {
        return this.active.get();
    }

    public float getTargetRotation() {
        return this.isEnabled() ? 0.0f : -1.5707964f;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
        this.tickCounter = 10;
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)OpenBlocks.Blocks.target);
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.setEnabled(true);
    }

    public void onNeighbourChanged(Block block) {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)this.field_145850_b;
        boolean isPowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (isPowered == this.isEnabled()) {
            return;
        }
        this.dropArrowsAsItems(world);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, isPowered ? "openblocks:target.open" : "openblocks:target.close", 0.5f, 1.0f);
        this.setEnabled(isPowered);
        this.sync();
    }

    private void dropArrowsAsItems(WorldServer world) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.1), (double)((double)this.field_145848_d - 0.1), (double)((double)this.field_145849_e - 0.1), (double)((double)this.field_145851_c + 1.1), (double)((double)this.field_145848_d + 1.1), (double)((double)this.field_145849_e + 1.1));
        final List arrows = this.field_145850_b.func_72872_a(EntityArrow.class, aabb);
        final ArrayList drops = Lists.newArrayList();
        int failed = (Integer)FakePlayerPool.instance.executeOnPlayer(world, (FakePlayerPool.PlayerUserReturning)new FakePlayerPool.PlayerUserReturning<Integer>(){

            public Integer usePlayer(OpenModsFakePlayer fakePlayer) {
                int failed = 0;
                for (EntityArrow arrow : arrows) {
                    try {
                        arrow.func_70100_b_((EntityPlayer)fakePlayer);
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Failed to collide arrow %s with fake player, returing vanilla one", (Object[])new Object[]{arrow});
                        ++failed;
                    }
                }
                InventoryPlayer inventory = fakePlayer.field_71071_by;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack == null) continue;
                    drops.add(stack);
                    inventory.func_70299_a(i, null);
                }
                return failed;
            }
        });
        for (ItemStack drop : drops) {
            BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (ItemStack)drop);
        }
        if (failed > 0) {
            BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (ItemStack)new ItemStack(Items.field_151032_g, failed));
        }
    }

    static {
        TileEntityTarget.addClass(FLANS_BULLET);
        PROJECTILE_SELECTOR = new IEntitySelector(){

            public boolean func_82704_a(Entity p_82704_1_) {
                return EXTRA_PROJECTILE_CLASSES.contains(p_82704_1_.getClass());
            }
        };
    }
}

