/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemPaintCan;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomHarvestDrops;
import openmods.api.IPlaceAwareTile;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityPaintCan
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile,
ICustomHarvestDrops {
    private SyncableInt color;
    private SyncableInt amount;

    protected void createSyncedFields() {
        this.color = new SyncableInt();
        this.amount = new SyncableInt();
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.color.set(ItemPaintCan.getColorFromStack(stack));
        this.amount.set(ItemPaintCan.getAmountFromStack(stack));
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack heldStack;
        if (!this.field_145850_b.field_72995_K && this.amount.get() > 0 && (heldStack = player.func_70694_bm()) != null && heldStack.func_77973_b() instanceof ItemPaintBrush) {
            ItemPaintBrush.setColor(heldStack, this.color.get());
            heldStack.func_77964_b(0);
            this.amount.modify(-1);
            this.sync();
            this.field_145850_b.func_72956_a((Entity)player, "game.neutral.swim.splash", 0.1f, 1.2f);
        }
        if (this.amount.get() <= 0 && !this.field_145850_b.field_72995_K) {
            ItemStack item = new ItemStack(Items.field_151133_ar);
            BlockUtils.dropItemStackInWorld((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (ItemStack)item);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return false;
    }

    public int getColor() {
        return this.color.get();
    }

    public int getAmount() {
        return this.amount.get();
    }

    public void setAmount(int amt) {
        this.amount.set(amt);
    }

    public boolean suppressNormalHarvestDrops() {
        return true;
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops) {
        drops.add(ItemPaintCan.createStack(this.getColor(), this.getAmount()));
    }
}

