/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityCanvas;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockCanvas
extends OpenBlock {
    private int layer = 0;
    private int renderSide = 0;
    public IIcon baseIcon;
    public IIcon wallpaper;

    public BlockCanvas() {
        this(Material.field_151583_m);
    }

    public BlockCanvas(Material material) {
        super(material);
    }

    public boolean shouldOverrideHarvestWithTeLogic() {
        return true;
    }

    public void func_149651_a(IIconRegister registry) {
        this.field_149761_L = this.baseIcon = registry.func_94245_a("openblocks:canvas");
        this.wallpaper = registry.func_94245_a("openblocks:wallpaper");
        for (Stencil stencil : Stencil.values()) {
            stencil.registerBlockIcons(registry);
        }
    }

    public void setLayerForRender(int layer) {
        this.layer = layer;
    }

    public void setSideForRender(int side) {
        this.renderSide = side;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side == this.renderSide && super.func_149646_a(world, x, y, z, side);
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class));
        return tile != null ? tile.getColorForRender(this.renderSide, this.layer) : -1;
    }

    public IIcon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class));
        if (tile != null) {
            return tile.getTextureForRender(this.renderSide, this.layer);
        }
        return super.getUnrotatedTexture(direction, world, x, y, z);
    }

    public static void replaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block.func_149688_o() == Material.field_151592_s) {
            world.func_147449_b(x, y, z, (Block)OpenBlocks.Blocks.canvasGlass);
        } else {
            world.func_147449_b(x, y, z, (Block)OpenBlocks.Blocks.canvas);
        }
        TileEntityCanvas tile = (TileEntityCanvas)world.func_147438_o(x, y, z);
        tile.setPaintedBlockBlock(block, meta);
    }
}

