/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.trophy.BlazeBehavior;
import openblocks.trophy.CaveSpiderBehavior;
import openblocks.trophy.CreeperBehavior;
import openblocks.trophy.EndermanBehavior;
import openblocks.trophy.ITrophyBehavior;
import openblocks.trophy.ItemDropBehavior;
import openblocks.trophy.MooshroomBehavior;
import openblocks.trophy.SkeletonBehavior;
import openblocks.trophy.SnowmanBehavior;
import openblocks.trophy.SquidBehavior;
import openblocks.trophy.WitchBehavior;
import openmods.Log;
import openmods.reflection.ReflectionHelper;
import openmods.utils.ItemUtils;

public class TrophyHandler {
    private static final Random DROP_RAND = new Random();
    private static final Map<Trophy, Entity> entityCache = Maps.newHashMap();

    public static Entity getEntityFromCache(Trophy trophy) {
        Entity entity = entityCache.get((Object)trophy);
        if (entity == null) {
            entity = trophy.createEntity();
            entityCache.put(trophy, entity);
        }
        return entity;
    }

    private static Entity setSlimeSize(Entity entity, int size) {
        try {
            ReflectionHelper.call((Object)entity, (String[])new String[]{"func_70799_a", "setSlimeSize"}, (Object[])new Object[]{ReflectionHelper.primitive((int)size)});
        }
        catch (Exception e) {
            Log.warn((Throwable)e, (String)"Can't update slime size", (Object[])new Object[0]);
        }
        return entity;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Trophy mobTrophy;
        Entity entity;
        String entityName;
        if (event.recentlyHit && DROP_RAND.nextDouble() < Config.trophyDropChance * (double)event.lootingLevel && !Strings.isNullOrEmpty((String)(entityName = EntityList.func_75621_b((Entity)(entity = event.entity)))) && (mobTrophy = (Trophy)((Object)Trophy.TYPES.get(entityName))) != null) {
            EntityItem drop = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, mobTrophy.getItemStack());
            drop.field_145804_b = 10;
            event.drops.add(drop);
        }
    }

    public static enum Trophy {
        Wolf,
        Chicken(new ItemDropBehavior(10000, new ItemStack(Items.field_151110_aK), "mob.chicken.plop")),
        Cow(new ItemDropBehavior(20000, new ItemStack(Items.field_151116_aA))),
        Creeper(new CreeperBehavior()),
        Skeleton(new SkeletonBehavior()),
        PigZombie(new ItemDropBehavior(20000, new ItemStack(Items.field_151074_bl))),
        Bat(1.0, -0.3),
        Zombie,
        Witch(0.35, new WitchBehavior()),
        Villager,
        Ozelot{

            @Override
            protected Entity createEntity() {
                Entity entity = super.createEntity();
                try {
                    ((EntityOcelot)entity).func_70903_f(true);
                }
                catch (ClassCastException e) {
                    Log.warn((String)"Invalid cat entity class: %s", (Object[])new Object[]{entity.getClass()});
                }
                return entity;
            }
        }
        ,
        Sheep,
        Blaze(new BlazeBehavior()),
        Silverfish,
        Spider,
        CaveSpider(new CaveSpiderBehavior()),
        Slime(0.6){

            @Override
            protected Entity createEntity() {
                return TrophyHandler.setSlimeSize(super.createEntity(), 1);
            }
        }
        ,
        Ghast(0.1, 0.2),
        Enderman(0.3, new EndermanBehavior()),
        LavaSlime(0.6){

            @Override
            protected Entity createEntity() {
                return TrophyHandler.setSlimeSize(super.createEntity(), 1);
            }
        }
        ,
        Squid(0.3, 0.5, new SquidBehavior()),
        MushroomCow(new MooshroomBehavior()),
        VillagerGolem(0.3),
        SnowMan(new SnowmanBehavior()),
        Pig(new ItemDropBehavior(20000, new ItemStack(Items.field_151147_al)));

        private double scale = 0.4;
        private double verticalOffset = 0.0;
        private ITrophyBehavior behavior;
        private static final Map<String, Trophy> TYPES;
        public static final Trophy[] VALUES;

        private Trophy() {
        }

        private Trophy(ITrophyBehavior behavior) {
            this.behavior = behavior;
        }

        private Trophy(double scale) {
            this.scale = scale;
        }

        private Trophy(double scale, ITrophyBehavior behavior) {
            this.scale = scale;
            this.behavior = behavior;
        }

        private Trophy(double scale, double verticalOffset) {
            this(scale);
            this.verticalOffset = verticalOffset;
        }

        private Trophy(double scale, double verticalOffset, ITrophyBehavior behavior) {
            this(scale, verticalOffset);
            this.behavior = behavior;
        }

        public double getVerticalOffset() {
            return this.verticalOffset;
        }

        public double getScale() {
            return this.scale;
        }

        public Entity getEntity() {
            return TrophyHandler.getEntityFromCache(this);
        }

        public ItemStack getItemStack() {
            ItemStack stack = new ItemStack((Block)OpenBlocks.Blocks.trophy, 1, this.ordinal());
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74778_a("entity", this.toString());
            return stack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playSound(World world, double x, double y, double z) {
            if (world == null) {
                return;
            }
            Entity e = this.getEntity();
            if (e instanceof EntityLiving) {
                e.field_70165_t = x;
                e.field_70163_u = y;
                e.field_70161_v = z;
                Entity entity = e;
                synchronized (entity) {
                    e.field_70170_p = world;
                    ((EntityLiving)e).func_70642_aH();
                    e.field_70170_p = null;
                }
            }
        }

        public int executeActivateBehavior(TileEntityTrophy tile, EntityPlayer player) {
            if (this.behavior != null) {
                return this.behavior.executeActivateBehavior(tile, player);
            }
            return 0;
        }

        public void executeTickBehavior(TileEntityTrophy tile) {
            if (this.behavior != null) {
                this.behavior.executeTickBehavior(tile);
            }
        }

        protected Entity createEntity() {
            return EntityList.func_75620_a((String)this.toString(), null);
        }

        static {
            TYPES = Maps.newHashMap();
            for (Trophy t : Trophy.values()) {
                TYPES.put(t.name(), t);
            }
            VALUES = Trophy.values();
        }
    }
}

