/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.PlayerInventoryStore;
import openblocks.common.tileentity.TileEntityGrave;
import openmods.Log;
import openmods.inventory.GenericInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.TagUtils;
import openmods.world.DelayedActionTickHandler;
import org.apache.logging.log4j.Level;

public class PlayerDeathHandler {
    private static final IGravePlacementChecker POLITE = new IGravePlacementChecker(){

        @Override
        public boolean canPlaceGrave(World world, int x, int y, int z) {
            if (!world.func_72899_e(x, y, z)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            return block.isAir((IBlockAccess)world, x, y, z) || block.isReplaceable((IBlockAccess)world, x, y, z);
        }
    };
    private static final IGravePlacementChecker BRUTAL = new IGravePlacementChecker(){

        @Override
        public boolean canPlaceGrave(World world, int x, int y, int z) {
            if (!world.func_72899_e(x, y, z)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            return block.func_149712_f(world, x, y, z) >= 0.0f && world.func_147438_o(x, y, z) == null;
        }
    };

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerDrops(PlayerDropsEvent event) {
        World world = event.entityPlayer.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (Config.debugGraves) {
            PlayerDeathHandler.dumpDebugInfo(event);
        }
        EntityPlayer player = event.entityPlayer;
        if (OpenBlocks.Blocks.grave == null) {
            Log.debug((String)"Graves disabled, not placing (player '%s')", (Object[])new Object[]{player});
            return;
        }
        if (player instanceof FakePlayer) {
            Log.debug((String)"'%s' (%s) is a fake player, ignoring", (Object[])new Object[]{player, player.getClass()});
            return;
        }
        ArrayList drops = event.drops;
        if (drops.isEmpty()) {
            Log.debug((String)"No drops from player '%s'", (Object[])new Object[]{player});
            return;
        }
        GameRules gameRules = world.func_82736_K();
        if (gameRules.func_82766_b("keepInventory") || !gameRules.func_82766_b("openblocks:spawn_graves")) {
            Log.debug((String)"Graves disabled by gamerule (player '%s')", (Object[])new Object[]{player});
            return;
        }
        Log.debug((String)"Scheduling grave placement for player '%s':'%s' with %d items", (Object[])new Object[]{player, player.func_146103_bH(), drops.size()});
        DelayedActionTickHandler.INSTANCE.addTickCallback(world, (Runnable)new GraveCallable(world, player, drops));
        drops.clear();
        event.setCanceled(true);
    }

    private static void dumpDebugInfo(PlayerDropsEvent event) {
        Log.debug((String)"Trying to spawn grave for player '%s':'%s'", (Object[])new Object[]{event.entityPlayer, event.entityPlayer.func_146103_bH()});
        int i = 0;
        for (EntityItem e : event.drops) {
            Log.debug((String)"\tGrave drop %d: %s -> %s", (Object[])new Object[]{i++, e.getClass(), e.func_92059_d()});
        }
        ListenerList listeners = event.getListenerList();
        try {
            int busId = 0;
            while (true) {
                Log.debug((String)"Dumping event %s listeners on bus %d", (Object[])new Object[]{event.getClass(), busId});
                for (IEventListener listener : listeners.getListeners(busId)) {
                    if (listener instanceof ASMEventHandler) {
                        try {
                            ASMEventHandler handler = (ASMEventHandler)listener;
                            Object o = ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)handler, (String[])new String[]{"handler"});
                            Log.debug((String)"\t'%s' (handler %s, priority: %s)", (Object[])new Object[]{handler, o.getClass(), handler.getPriority()});
                            continue;
                        }
                        catch (Throwable e) {
                            Log.log((Level)Level.DEBUG, (Throwable)e, (String)"Exception while getting field", (Object[])new Object[0]);
                        }
                    }
                    Log.debug((String)"\t%s", (Object[])new Object[]{listener.getClass()});
                }
                ++busId;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    private static class GraveCallable
    implements Runnable {
        private final GameProfile stiffId;
        private final int posX;
        private final int posY;
        private final int posZ;
        private final List<EntityItem> loot;
        private final WeakReference<World> world;

        public GraveCallable(World world, EntityPlayer exPlayer, List<EntityItem> loot) {
            this.stiffId = exPlayer.func_146103_bH();
            this.posX = MathHelper.func_76128_c((double)exPlayer.field_70165_t);
            this.posY = MathHelper.func_76128_c((double)exPlayer.field_70163_u);
            this.posZ = MathHelper.func_76128_c((double)exPlayer.field_70161_v);
            this.world = new WeakReference<World>(world);
            this.loot = ImmutableList.copyOf(loot);
        }

        private boolean tryPlaceGrave(World world, final int x, final int y, final int z) {
            world.func_147465_d(x, y, z, (Block)OpenBlocks.Blocks.grave, 0, 3);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile == null || !(tile instanceof TileEntityGrave)) {
                return false;
            }
            TileEntityGrave grave = (TileEntityGrave)tile;
            GenericInventory loot = new GenericInventory("tmpplayer", false, this.loot.size());
            for (EntityItem entityItem : this.loot) {
                ItemStack stack = entityItem.func_92059_d();
                if (stack == null) continue;
                ItemDistribution.insertItemIntoInventory((IInventory)loot, (ItemStack)stack.func_77946_l());
            }
            if (Config.backupGraves) {
                try {
                    File backup = PlayerInventoryStore.instance.storeInventory((IInventory)loot, this.stiffId.getName(), "grave", world, new PlayerInventoryStore.ExtrasFiller(){

                        @Override
                        public void addExtras(NBTTagCompound meta) {
                            meta.func_74778_a("PlayerName", GraveCallable.this.stiffId.getName());
                            meta.func_74778_a("PlayerUUID", GraveCallable.this.stiffId.getId().toString());
                            meta.func_74782_a("GraveLocation", (NBTBase)TagUtils.store((int)x, (int)y, (int)z));
                            meta.func_74782_a("PlayerLocation", (NBTBase)TagUtils.store((int)GraveCallable.this.posX, (int)GraveCallable.this.posY, (int)GraveCallable.this.posZ));
                        }
                    });
                    Log.info((String)"Grave backup for player %s saved to %s", (Object[])new Object[]{this.stiffId, backup});
                }
                catch (Throwable t) {
                    Log.warn((String)"Failed to store grave backup for player %s", (Object[])new Object[]{this.stiffId});
                }
            }
            grave.setUsername(this.stiffId.getName());
            grave.setLoot((IInventory)loot);
            return true;
        }

        private boolean tryPlaceGrave(World world, IGravePlacementChecker checker) {
            for (int distance = 0; distance < Config.graveSpawnRange; ++distance) {
                for (int checkX = this.posX - distance; checkX <= this.posX + distance; ++checkX) {
                    for (int checkY = this.posY - distance; checkY <= this.posY + distance; ++checkY) {
                        for (int checkZ = this.posZ - distance; checkZ <= this.posZ + distance; ++checkZ) {
                            if (!checker.canPlaceGrave(world, checkX, checkY, checkZ) || !this.tryPlaceGrave(world, checkX, checkY, checkZ)) continue;
                            Log.debug((String)"Placing grave for player '%s' @ (%d,%d,%d)", (Object[])new Object[]{this.stiffId, checkX, checkY, checkZ});
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void run() {
            World world = (World)this.world.get();
            if (world == null) {
                Log.warn((String)"Lost world while placing player %s grave", (Object[])new Object[]{this.stiffId});
                return;
            }
            if (this.tryPlaceGrave(world, POLITE)) {
                return;
            }
            if (Config.destructiveGraves) {
                Log.warn((String)"Failed to place grave for player %s, going berserk", (Object[])new Object[]{this.stiffId});
                if (this.tryPlaceGrave(world, BRUTAL)) {
                    return;
                }
            }
            for (EntityItem drop : this.loot) {
                world.func_72838_d((Entity)drop);
            }
        }
    }

    private static interface IGravePlacementChecker {
        public boolean canPlaceGrave(World var1, int var2, int var3, int var4);
    }
}

