/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumicenergistics.common.items.ItemCraftingAspect;

public class DistillationPatternHelper {
    private static final String NBTKEY_AE_IN = "in";
    private static final String NBTKEY_AE_OUT = "out";
    private static final String NBTKEY_AE_ISCRAFTING = "crafting";
    private static final String NBTKEY_AE_CAN_SUB = "substitute";
    protected ItemStack output = null;
    protected ItemStack input = null;

    public void encodePattern(ItemStack pattern) {
        if (pattern == null) {
            return;
        }
        if (this.input == null || this.output == null) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList inTags = new NBTTagList();
        inTags.func_74742_a((NBTBase)this.input.func_77955_b(new NBTTagCompound()));
        NBTTagList outTags = new NBTTagList();
        outTags.func_74742_a((NBTBase)this.output.func_77955_b(new NBTTagCompound()));
        data.func_74757_a(NBTKEY_AE_CAN_SUB, false);
        data.func_74757_a(NBTKEY_AE_ISCRAFTING, false);
        data.func_74782_a(NBTKEY_AE_IN, (NBTBase)inTags);
        data.func_74782_a(NBTKEY_AE_OUT, (NBTBase)outTags);
        pattern.func_77982_d(data);
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean isValid() {
        return this.output != null && this.input != null;
    }

    public void readPattern(ItemStack pattern) {
        this.reset();
        if (pattern == null) {
            return;
        }
        if (!pattern.func_77942_o()) {
            return;
        }
        NBTTagCompound data = pattern.func_77978_p();
        NBTTagList inTags = data.func_150295_c(NBTKEY_AE_IN, 10);
        NBTTagList outTags = data.func_150295_c(NBTKEY_AE_OUT, 10);
        if (outTags.func_74745_c() < 1 || inTags.func_74745_c() < 1) {
            return;
        }
        this.setOutputItem(ItemStack.func_77949_a((NBTTagCompound)outTags.func_150305_b(0)));
        this.setInputItem(ItemStack.func_77949_a((NBTTagCompound)inTags.func_150305_b(0)));
        if (this.input == null || this.output == null) {
            this.reset();
            return;
        }
    }

    public void reset() {
        this.output = null;
        this.input = null;
    }

    public void setInputItem(ItemStack inputItem) {
        this.input = inputItem.func_77946_l();
        this.input.field_77994_a = 1;
    }

    public void setOutputItem(ItemStack outputItem) {
        this.output = outputItem != null && !(outputItem.func_77973_b() instanceof ItemCraftingAspect) ? null : (ItemCraftingAspect.getAspect(outputItem) == null ? null : outputItem);
    }

    public boolean setPatternItems(ItemStack inputItem, ItemStack outputItem) {
        this.setInputItem(inputItem);
        this.setOutputItem(outputItem);
        return this.isValid();
    }
}

