/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.items;

import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumicenergistics.common.ThaumicEnergistics;
import thaumicenergistics.common.integration.tc.AspectHooks;
import thaumicenergistics.common.items.ItemEnum;

public class ItemCraftingAspect
extends Item {
    private static final String NBTKEY_ASPECT = "Aspect";

    public ItemCraftingAspect() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(ThaumicEnergistics.ThETab);
        this.func_77655_b("itemCraftingAspect");
    }

    public static boolean canPlayerSeeAspect(@Nonnull EntityPlayer player, @Nonnull Aspect aspect) {
        return Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(player.func_70005_c_(), aspect);
    }

    public static ItemStack createStackForAspect(Aspect aspect, int amount) {
        ItemStack stack = ItemEnum.CRAFTING_ASPECT.getStack(amount);
        ItemCraftingAspect.setAspect(stack, aspect);
        return stack;
    }

    public static Aspect getAspect(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return ItemCraftingAspect.getAspect(itemStack.func_77978_p());
    }

    public static Aspect getAspect(NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b(NBTKEY_ASPECT)) {
            return Aspect.getAspect((String)tag.func_74779_i(NBTKEY_ASPECT));
        }
        return null;
    }

    public static void setAspect(ItemStack stack, Aspect aspect) {
        if (aspect == null) {
            stack.func_77982_d(null);
            return;
        }
        NBTTagCompound tag = null;
        if (!stack.func_77942_o()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        tag.func_74778_a(NBTKEY_ASPECT, aspect.getTag());
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedInfo) {
        super.func_77624_a(stack, player, list, advancedInfo);
        Aspect aspect = ItemCraftingAspect.getAspect(stack);
        if (aspect != null) {
            if (ItemCraftingAspect.canPlayerSeeAspect(player, aspect)) {
                list.add(aspect.getLocalizedDescription());
                ModContainer mod = AspectHooks.aspectToMod.getOrDefault(aspect, null);
                if (mod != null) {
                    list.add(EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC.toString() + mod.getName());
                }
            } else {
                list.add(StatCollector.func_74838_a((String)"tc.aspect.unknown"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        Aspect aspect = ItemCraftingAspect.getAspect(stack);
        if (aspect != null) {
            return aspect.getColor();
        }
        return super.func_82790_a(stack, renderPass);
    }

    public String func_77653_i(ItemStack stack) {
        return this.func_77657_g(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        EntityClientPlayerMP player;
        Aspect aspect = ItemCraftingAspect.getAspect(stack);
        if (aspect != null && ItemCraftingAspect.canPlayerSeeAspect((EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g), aspect)) {
            return aspect.getName();
        }
        return "tc.aspect.unknown";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }
}

