/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.tiles.TileEmcDirection;
import moze_intel.projecte.handlers.TileEntityHandler;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.CondenserSyncPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.NBTWhitelist;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class CondenserTile
extends TileEmcDirection
implements IInventory,
ISidedInventory,
IEmcAcceptor {
    protected ItemStack[] inventory = new ItemStack[92];
    private ItemStack lock;
    protected boolean loadChecks = false;
    protected boolean isAcceptingEmc;
    private int ticksSinceSync;
    public int displayEmc;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    public int requiredEmc;

    public void func_145845_h() {
        this.updateChest();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.loadChecks) {
            TileEntityHandler.addCondenser(this);
            this.checkLockAndUpdate();
            this.loadChecks = true;
        }
        this.displayEmc = (int)this.getStoredEmc();
        if (this.lock != null && this.requiredEmc != 0) {
            this.condense();
        }
        if (this.numPlayersUsing > 0) {
            PacketHandler.sendToAllAround(new CondenserSyncPKT(this.displayEmc, this.requiredEmc, this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 8.0));
        }
    }

    public void checkLockAndUpdate() {
        this.lock = this.inventory[0];
        if (this.lock == null) {
            this.displayEmc = 0;
            this.requiredEmc = 0;
            this.isAcceptingEmc = false;
            return;
        }
        if (EMCHelper.doesItemHaveEmc(this.lock)) {
            int lockEmc = EMCHelper.getEmcValue(this.lock);
            if (this.requiredEmc != lockEmc) {
                this.requiredEmc = lockEmc;
                this.isAcceptingEmc = true;
            }
        } else {
            this.lock = null;
            this.inventory[0] = null;
            this.displayEmc = 0;
            this.requiredEmc = 0;
            this.isAcceptingEmc = false;
        }
    }

    protected void condense() {
        for (int i = 1; i < 92; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || this.isStackEqualToLock(stack)) continue;
            if (stack.field_77994_a <= 0) {
                this.inventory[i] = null;
                continue;
            }
            this.func_70298_a(i, 1);
            this.addEMC(EMCHelper.getEmcValue(stack));
            break;
        }
        if (this.getStoredEmc() >= (double)this.requiredEmc && this.hasSpace()) {
            this.removeEMC(this.requiredEmc);
            this.pushStack();
        }
    }

    protected void pushStack() {
        int slot = this.getSlotForStack();
        if (slot == 0) {
            return;
        }
        if (this.inventory[slot] == null) {
            ItemStack lockCopy = this.lock.func_77946_l();
            if (lockCopy.func_77942_o() && !NBTWhitelist.shouldDupeWithNBT(lockCopy)) {
                lockCopy.func_77982_d(new NBTTagCompound());
            }
            this.inventory[slot] = lockCopy;
        } else {
            ++this.inventory[slot].field_77994_a;
        }
        this.func_70296_d();
    }

    protected int getSlotForStack() {
        for (int i = 1; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) {
                return i;
            }
            if (!this.isStackEqualToLock(stack) || stack.field_77994_a >= stack.func_77976_d()) continue;
            return i;
        }
        return 0;
    }

    protected boolean hasSpace() {
        for (int i = 1; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) {
                return true;
            }
            if (!this.isStackEqualToLock(stack) || stack.field_77994_a >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    protected boolean isStackEqualToLock(ItemStack stack) {
        if (this.lock == null) {
            return false;
        }
        if (NBTWhitelist.shouldDupeWithNBT(this.lock)) {
            return ItemHelper.areItemStacksEqual(this.lock, stack);
        }
        return ItemHelper.areItemStacksEqualIgnoreNBT(this.lock, stack);
    }

    public int getProgressScaled() {
        if (this.requiredEmc == 0) {
            return 0;
        }
        if (this.displayEmc >= this.requiredEmc) {
            return 102;
        }
        return this.displayEmc * 102 / this.requiredEmc;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.loadChecks = false;
        if (!this.field_145850_b.field_72995_K) {
            TileEntityHandler.removeCondenser(this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subNBT = list.func_150305_b(i);
            this.inventory[subNBT.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)subNBT);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            subNBT.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int qnt) {
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.field_77994_a <= qnt) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(qnt);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "tile.pe_condenser.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void updateChest() {
        double adjustedZCoord;
        double adjustedXCoord;
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, ObjHandler.condenser, 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float angleIncrement = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            adjustedXCoord = (double)this.field_145851_c + 0.5;
            adjustedZCoord = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(adjustedXCoord, (double)this.field_145848_d + 0.5, adjustedZCoord, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float var8 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += angleIncrement) : (this.lidAngle -= angleIncrement);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && var8 >= 0.5f) {
                adjustedXCoord = (double)this.field_145851_c + 0.5;
                adjustedZCoord = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(adjustedXCoord, (double)this.field_145848_d + 0.5, adjustedZCoord, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int number, int arg) {
        if (number == 1) {
            this.numPlayersUsing = arg;
            return true;
        }
        return super.func_145842_c(number, arg);
    }

    public void func_70295_k_() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, ObjHandler.condenser, 1, this.numPlayersUsing);
    }

    public void func_70305_f() {
        --this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, ObjHandler.condenser, 1, this.numPlayersUsing);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        return !this.isStackEqualToLock(stack) && EMCHelper.doesItemHaveEmc(stack);
    }

    public int[] func_94128_d(int side) {
        int[] slots = new int[this.inventory.length - 1];
        for (int i = 1; i < this.inventory.length; ++i) {
            slots[i - 1] = i;
        }
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (slot == 0) {
            return false;
        }
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        if (slot == 0) {
            return false;
        }
        return this.isStackEqualToLock(item);
    }

    @Override
    public double acceptEMC(ForgeDirection side, double toAccept) {
        if (this.isAcceptingEmc) {
            double toAdd = Math.min(this.maximumEMC - this.currentEMC, toAccept);
            this.addEMC(toAdd);
            return toAdd;
        }
        return 0.0;
    }
}

