/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.beans.ConstructorProperties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import logisticspipes.routing.PipeRoutingConnectionType;
import lombok.NonNull;
import net.minecraftforge.common.util.ForgeDirection;

public class LaserData {
    @NonNull
    private int posX;
    @NonNull
    private int posY;
    @NonNull
    private int posZ;
    @NonNull
    private ForgeDirection dir;
    @NonNull
    private EnumSet<PipeRoutingConnectionType> connectionType;
    private boolean finalPipe = true;
    private boolean startPipe = false;
    private int length = 1;

    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        data.writeByte(this.dir.ordinal());
        data.writeBoolean(this.finalPipe);
        data.writeBoolean(this.startPipe);
        data.writeInt(this.length);
        for (PipeRoutingConnectionType type : PipeRoutingConnectionType.values()) {
            data.writeBoolean(this.connectionType.contains((Object)type));
        }
    }

    public LaserData readData(DataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        this.dir = ForgeDirection.values()[data.readByte()];
        this.finalPipe = data.readBoolean();
        this.startPipe = data.readBoolean();
        this.length = data.readInt();
        this.connectionType = EnumSet.noneOf(PipeRoutingConnectionType.class);
        for (PipeRoutingConnectionType type : PipeRoutingConnectionType.values()) {
            if (!data.readBoolean()) continue;
            this.connectionType.add(type);
        }
        return this;
    }

    @NonNull
    public int getPosX() {
        return this.posX;
    }

    @NonNull
    public int getPosY() {
        return this.posY;
    }

    @NonNull
    public int getPosZ() {
        return this.posZ;
    }

    @NonNull
    public ForgeDirection getDir() {
        return this.dir;
    }

    @NonNull
    public EnumSet<PipeRoutingConnectionType> getConnectionType() {
        return this.connectionType;
    }

    public boolean isFinalPipe() {
        return this.finalPipe;
    }

    public boolean isStartPipe() {
        return this.startPipe;
    }

    public int getLength() {
        return this.length;
    }

    public LaserData setPosX(@NonNull int posX) {
        this.posX = posX;
        return this;
    }

    public LaserData setPosY(@NonNull int posY) {
        this.posY = posY;
        return this;
    }

    public LaserData setPosZ(@NonNull int posZ) {
        this.posZ = posZ;
        return this;
    }

    public LaserData setDir(@NonNull ForgeDirection dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        this.dir = dir;
        return this;
    }

    public LaserData setConnectionType(@NonNull EnumSet<PipeRoutingConnectionType> connectionType) {
        if (connectionType == null) {
            throw new NullPointerException("connectionType");
        }
        this.connectionType = connectionType;
        return this;
    }

    public LaserData setFinalPipe(boolean finalPipe) {
        this.finalPipe = finalPipe;
        return this;
    }

    public LaserData setStartPipe(boolean startPipe) {
        this.startPipe = startPipe;
        return this;
    }

    public LaserData setLength(int length) {
        this.length = length;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LaserData)) {
            return false;
        }
        LaserData other = (LaserData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosX() != other.getPosX()) {
            return false;
        }
        if (this.getPosY() != other.getPosY()) {
            return false;
        }
        if (this.getPosZ() != other.getPosZ()) {
            return false;
        }
        ForgeDirection this$dir = this.getDir();
        ForgeDirection other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        EnumSet<PipeRoutingConnectionType> this$connectionType = this.getConnectionType();
        EnumSet<PipeRoutingConnectionType> other$connectionType = other.getConnectionType();
        if (this$connectionType == null ? other$connectionType != null : !((Object)this$connectionType).equals(other$connectionType)) {
            return false;
        }
        if (this.isFinalPipe() != other.isFinalPipe()) {
            return false;
        }
        if (this.isStartPipe() != other.isStartPipe()) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LaserData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosX();
        result = result * 59 + this.getPosY();
        result = result * 59 + this.getPosZ();
        ForgeDirection $dir = this.getDir();
        result = result * 59 + ($dir == null ? 0 : $dir.hashCode());
        EnumSet<PipeRoutingConnectionType> $connectionType = this.getConnectionType();
        result = result * 59 + ($connectionType == null ? 0 : ((Object)$connectionType).hashCode());
        result = result * 59 + (this.isFinalPipe() ? 79 : 97);
        result = result * 59 + (this.isStartPipe() ? 79 : 97);
        result = result * 59 + this.getLength();
        return result;
    }

    public String toString() {
        return "LaserData(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ", dir=" + this.getDir() + ", connectionType=" + this.getConnectionType() + ", finalPipe=" + this.isFinalPipe() + ", startPipe=" + this.isStartPipe() + ", length=" + this.getLength() + ")";
    }

    @ConstructorProperties(value={"posX", "posY", "posZ", "dir", "connectionType"})
    public LaserData(@NonNull int posX, @NonNull int posY, @NonNull int posZ, @NonNull ForgeDirection dir, @NonNull EnumSet<PipeRoutingConnectionType> connectionType) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (connectionType == null) {
            throw new NullPointerException("connectionType");
        }
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.dir = dir;
        this.connectionType = connectionType;
    }

    public LaserData() {
    }
}

