/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.abstractions.entity;

import gnu.trove.map.hash.TObjectByteHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public final class EntityDataWatcher {
    private final DataWatcher watcher;
    private final TObjectByteHashMap<Enum<?>> idMap;

    public EntityDataWatcher(Entity trackedEntity) {
        this.watcher = trackedEntity.func_70096_w();
        this.idMap = new TObjectByteHashMap(8);
    }

    private void addObject(Enum<?> linkedEnum, Object obj) {
        int internalId = 30 - this.idMap.size();
        this.watcher.func_75682_a(internalId, obj);
        this.idMap.put(linkedEnum, (byte)internalId);
    }

    private void addObjectByType(Enum<?> linkedEnum, int type) {
        int internalId = 30 - this.idMap.size();
        this.watcher.func_82709_a(internalId, type);
        this.idMap.put(linkedEnum, (byte)internalId);
    }

    private int getId(Enum<?> linkedEnum) {
        byte value = this.idMap.get(linkedEnum);
        if (value == this.idMap.getNoEntryValue()) {
            throw new IllegalArgumentException("Enum was not registered in EntityDataWatcher!");
        }
        return value;
    }

    public void addBoolean(Enum<?> linkedEnum) {
        this.addObject(linkedEnum, (byte)0);
    }

    public void addBoolean(Enum<?> linkedEnum, boolean initialValue) {
        this.addObject(linkedEnum, (byte)(initialValue ? 1 : 0));
    }

    public boolean getBoolean(Enum<?> linkedEnum) {
        return this.watcher.func_75683_a(this.getId(linkedEnum)) == 1;
    }

    public void setBoolean(Enum<?> linkedEnum, boolean newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)((byte)(newValue ? 1 : 0)));
    }

    public void addByte(Enum<?> linkedEnum) {
        this.addObject(linkedEnum, (byte)0);
    }

    public void addByte(Enum<?> linkedEnum, int initialValue) {
        this.addObject(linkedEnum, (byte)initialValue);
    }

    public byte getByte(Enum<?> linkedEnum) {
        return this.watcher.func_75683_a(this.getId(linkedEnum));
    }

    public void setByte(Enum<?> linkedEnum, int newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)((byte)newValue));
    }

    public void addShort(Enum<?> linkedEnum) {
        this.addObject(linkedEnum, (short)0);
    }

    public void addShort(Enum<?> linkedEnum, int initialValue) {
        this.addObject(linkedEnum, (short)initialValue);
    }

    public short getShort(Enum<?> linkedEnum) {
        return this.watcher.func_75693_b(this.getId(linkedEnum));
    }

    public void setShort(Enum<?> linkedEnum, int newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)((short)newValue));
    }

    public void addInt(Enum<?> linkedEnum) {
        this.addObject(linkedEnum, 0);
    }

    public void addInt(Enum<?> linkedEnum, int initialValue) {
        this.addObject(linkedEnum, initialValue);
    }

    public int getInt(Enum<?> linkedEnum) {
        return this.watcher.func_75679_c(this.getId(linkedEnum));
    }

    public void setInt(Enum<?> linkedEnum, int newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)newValue);
    }

    public void addFloat(Enum<?> linkedEnum) {
        this.addObject(linkedEnum, Float.valueOf(0.0f));
    }

    public void addFloat(Enum<?> linkedEnum, float initialValue) {
        this.addObject(linkedEnum, Float.valueOf(initialValue));
    }

    public float getFloat(Enum<?> linkedEnum) {
        return this.watcher.func_111145_d(this.getId(linkedEnum));
    }

    public void setFloat(Enum<?> linkedEnum, float newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)Float.valueOf(newValue));
    }

    public void addString(Enum<?> linkedEnum) {
        this.addObject(linkedEnum, "");
    }

    public void addString(Enum<?> linkedEnum, String initialValue) {
        this.addObject(linkedEnum, initialValue);
    }

    public String getString(Enum<?> linkedEnum) {
        return this.watcher.func_75681_e(this.getId(linkedEnum));
    }

    public void setString(Enum<?> linkedEnum, String newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)newValue);
    }

    public void addItemStack(Enum<?> linkedEnum) {
        this.addObjectByType(linkedEnum, 5);
    }

    public void addItemStack(Enum<?> linkedEnum, ItemStack initialValue) {
        this.addObject(linkedEnum, initialValue);
    }

    @Nullable
    public ItemStack getItemStack(Enum<?> linkedEnum) {
        return this.watcher.func_82710_f(this.getId(linkedEnum));
    }

    public void setItemStack(Enum<?> linkedEnum, @Nullable ItemStack newValue) {
        this.watcher.func_75692_b(this.getId(linkedEnum), (Object)newValue);
    }
}

