/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.handlers;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.AnimatedFloat;
import chylex.hee.gui.helpers.KeyState;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.TimeUnit;

@SideOnly(value=Side.CLIENT)
public class CompendiumScrollHandler {
    private static final int extraHeight = 48;
    private final GuiEnderCompendium gui;
    private final int totalHeight;
    private final AnimatedFloat offset;
    private final AnimatedFloat scrollSpeed;
    private float offsetPrev;
    private float offsetDrag;
    private float offsetDragPeak;
    private float offsetInertia;
    private float scrollBy;
    private int dragMouseY;
    private long lastWheelTime;

    public CompendiumScrollHandler(GuiEnderCompendium compendium, int totalHeight) {
        this.gui = compendium;
        this.totalHeight = totalHeight;
        this.offset = new AnimatedFloat(AnimatedFloat.Easing.CUBIC);
        this.offset.set(48.0f);
        this.scrollSpeed = new AnimatedFloat(AnimatedFloat.Easing.LINEAR);
    }

    public void init() {
        KeyState.startTracking(199);
        KeyState.startTracking(207);
        KeyState.startTracking(200);
        KeyState.startTracking(208);
        KeyState.startTracking(201);
        KeyState.startTracking(209);
        KeyState.startTracking(this.gui.field_146297_k.field_71474_y.field_74351_w.func_151463_i());
        KeyState.startTracking(this.gui.field_146297_k.field_71474_y.field_74368_y.func_151463_i());
    }

    public float getOffset(float partialTickTime) {
        return this.offsetPrev + (this.offset.value() - this.offsetPrev) * partialTickTime;
    }

    public boolean isAnimating() {
        return this.offset.isAnimating();
    }

    public void moveTo(float newY, boolean animate) {
        newY = this.clampOffset(newY);
        if (animate) {
            this.offset.startAnimation(this.offset.value(), newY, 0.5f);
        } else {
            this.offset.set(newY);
        }
    }

    public void onMouseClick(int mouseX, int mouseY) {
        this.dragMouseY = mouseY;
    }

    public void onMouseDrag(int mouseX, int mouseY) {
        if (this.dragMouseY != Integer.MIN_VALUE) {
            this.offsetDrag += (float)(this.dragMouseY - mouseY);
            this.dragMouseY = mouseY;
            if (Math.abs(this.offsetDrag) > Math.abs(this.offsetDragPeak) || !MathUtil.floatEquals(Math.signum(this.offsetDrag), Math.signum(this.offsetDragPeak))) {
                this.offsetDragPeak = this.offsetDrag;
            }
        }
    }

    public void onMouseRelease(int mouseX, int mouseY) {
        if (this.dragMouseY != Integer.MIN_VALUE) {
            this.dragMouseY = Integer.MIN_VALUE;
            if (Math.abs(this.offsetDrag / GuiEnderCompendium.getScaleMultiplier()) > 2.0f && Math.abs(this.offsetDragPeak / GuiEnderCompendium.getScaleMultiplier()) > 20.0f) {
                this.offsetInertia = (float)Math.pow(Math.abs(this.offsetDragPeak * GuiEnderCompendium.getScaleMultiplier()), 1.25) * Math.signum(this.offsetDragPeak);
                this.offsetDragPeak = 0.0f;
            }
        }
    }

    public void onMouseWheel(int value) {
        this.scrollBy = Math.max(Math.abs(this.scrollBy), (float)Math.abs(value / 2) * GuiEnderCompendium.getScaleMultiplier()) * Math.signum(value);
        this.scrollSpeed.startAnimation(this.scrollSpeed.value(), 1.0f, 0.0f, this.lastWheelTime == 0L);
        this.lastWheelTime = System.nanoTime();
    }

    public boolean onKeyboardDown(int keyCode) {
        if (keyCode == 200 || keyCode == this.gui.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.startScrolling((float)this.gui.field_146295_m * GuiEnderCompendium.getScaleMultiplier() / 10.0f);
        } else if (keyCode == 208 || keyCode == this.gui.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.startScrolling((float)(-this.gui.field_146295_m) * GuiEnderCompendium.getScaleMultiplier() / 10.0f);
        } else if (keyCode == 201) {
            this.startScrolling((float)this.gui.field_146295_m * GuiEnderCompendium.getScaleMultiplier() / 2.0f);
        } else if (keyCode == 209) {
            this.startScrolling((float)(-this.gui.field_146295_m) * GuiEnderCompendium.getScaleMultiplier() / 2.0f);
        } else if (keyCode == 199) {
            this.stopScrolling(true);
            this.moveTo(2.1474836E9f, true);
        } else if (keyCode == 207) {
            this.stopScrolling(true);
            this.moveTo(-2.1474836E9f, true);
        } else {
            return false;
        }
        return true;
    }

    public void onKeyboardUp(int keyCode) {
        if (!this.restoreHeldKey()) {
            this.stopScrolling(false);
        }
    }

    private boolean restoreHeldKey() {
        for (int code : new int[]{199, 207, 201, 209, 200, 208, this.gui.field_146297_k.field_71474_y.field_74351_w.func_151463_i(), this.gui.field_146297_k.field_71474_y.field_74368_y.func_151463_i()}) {
            if (!KeyState.isHeld(code)) continue;
            this.onKeyboardDown(code);
            return true;
        }
        return false;
    }

    private void startScrolling(float by) {
        this.scrollBy = by;
        this.scrollSpeed.startAnimation(this.scrollSpeed.value(), 1.0f, 0.4f, true);
    }

    private void stopScrolling(boolean force) {
        if (force) {
            this.scrollBy = 0.0f;
            this.scrollSpeed.set(0.0f);
        } else {
            this.scrollSpeed.startAnimation(this.scrollSpeed.value(), 0.0f, 0.2f, true);
        }
    }

    private float clampOffset(float newValue) {
        if (newValue > 48.0f) {
            return 48.0f;
        }
        if (newValue < (float)(-this.totalHeight + this.gui.field_146295_m - 48)) {
            return this.totalHeight + 48 > this.gui.field_146295_m ? (float)(-this.totalHeight + this.gui.field_146295_m - 48) : 0.0f;
        }
        return newValue;
    }

    public void update() {
        this.offsetPrev = this.offset.value();
        this.offset.update(0.05f);
        this.scrollSpeed.update(0.05f);
        if (!MathUtil.floatEquals(this.scrollBy, 0.0f)) {
            if (MathUtil.floatEquals(this.scrollSpeed.value(), 0.0f) && !this.scrollSpeed.isAnimating()) {
                this.scrollBy = 0.0f;
            } else {
                this.offset.set(this.clampOffset(this.offset.value() + this.scrollBy * this.scrollSpeed.value()));
            }
        }
        if (!MathUtil.floatEquals(this.offsetDrag, 0.0f)) {
            this.offset.set(this.clampOffset(this.offset.value() - this.offsetDrag));
            this.offsetDrag = 0.0f;
            if (Math.abs(this.offsetInertia) <= 0.5f && CompendiumScrollHandler.isHoldingAnimationKey()) {
                this.restoreHeldKey();
            }
        }
        if (Math.abs(this.offsetInertia) > 0.5f) {
            float f = Math.abs(this.offsetInertia *= 0.7f);
            float f2 = CompendiumScrollHandler.isHoldingAnimationKey() ? 8.0f : 2.0f;
            if (f <= f2) {
                this.offsetInertia = 0.0f;
                this.restoreHeldKey();
            } else {
                this.offset.set(this.offset.value() - this.offsetInertia);
            }
        }
        if (!this.offset.isAnimating()) {
            this.offset.set(this.clampOffset(this.offset.value()));
        }
        if (this.lastWheelTime != 0L && TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastWheelTime) > 100L) {
            this.stopScrolling(false);
            this.restoreHeldKey();
            this.lastWheelTime = 0L;
        }
    }

    private static boolean isHoldingAnimationKey() {
        return KeyState.isHeld(199) || KeyState.isHeld(207);
    }
}

