/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.ImmutableVec3d;
import uk.co.qmunity.lib.vec.Quat;
import uk.co.qmunity.lib.vec.Vec2d;

public class Vec3d {
    public static final Vec3d center = new Vec3d(0.5, 0.5, 0.5).getImmutableCopy();
    protected double x;
    protected double y;
    protected double z;
    protected World w = null;

    public Vec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3d(double x, double y, double z, World w) {
        this(x, y, z);
        this.w = w;
    }

    public Vec3d(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e, te.func_145831_w());
    }

    public Vec3d(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vec3d(Vec3 vec, World w) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        this.w = w;
    }

    public boolean hasWorld() {
        return this.w != null;
    }

    public Vec3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec3d add(ForgeDirection dir) {
        return this.add(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vec3d add(Vec3d vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vec3d sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vec3d sub(ForgeDirection dir) {
        return this.sub(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Vec3d sub(Vec3d vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public Vec3d mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vec3d mul(double multiplier) {
        return this.mul(multiplier, multiplier, multiplier);
    }

    public Vec3d mul(ForgeDirection direction) {
        return this.mul(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vec3d multiply(Vec3d v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    public Vec3d div(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vec3d div(double multiplier) {
        return this.div(multiplier, multiplier, multiplier);
    }

    public Vec3d div(ForgeDirection direction) {
        return this.div(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vec3d rotate(Quat rotation) {
        Vec3d v = rotation.mul(this);
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Vec3d rotate(double x, double y, double z) {
        Quat rx = new Quat(new Vec3d(1.0, 0.0, 0.0), Math.toRadians(x));
        Quat ry = new Quat(new Vec3d(0.0, 1.0, 0.0), Math.toRadians(y));
        Quat rz = new Quat(new Vec3d(0.0, 0.0, 1.0), Math.toRadians(z));
        this.rotate(rx.mul(ry.mul(rz)));
        return this;
    }

    private Vec3d rotate(int x, int y, int z, Vec3d center) {
        this.sub(center).rotate(x, y, z).add(center);
        double mul = 1.0E7;
        this.setX((double)Math.round(this.getX() * mul) / mul);
        this.setY((double)Math.round(this.getY() * mul) / mul);
        this.setZ((double)Math.round(this.getZ() * mul) / mul);
        return this;
    }

    public Vec3d rotate(ForgeDirection face, Vec3d center) {
        switch (face) {
            case DOWN: {
                return this;
            }
            case UP: {
                return this.rotate(0, 0, 180, center);
            }
            case WEST: {
                return this.rotate(0, 0, -90, center);
            }
            case EAST: {
                return this.rotate(0, 0, 90, center);
            }
            case NORTH: {
                return this.rotate(90, 0, 0, center);
            }
            case SOUTH: {
                return this.rotate(-90, 0, 0, center);
            }
        }
        return this;
    }

    public Vec3d rotateUndo(ForgeDirection face, Vec3d center) {
        switch (face) {
            case DOWN: {
                return this;
            }
            case UP: {
                return this.rotate(0, 0, -180, center);
            }
            case WEST: {
                return this.rotate(0, 0, 90, center);
            }
            case EAST: {
                return this.rotate(0, 0, -90, center);
            }
            case NORTH: {
                return this.rotate(-90, 0, 0, center);
            }
            case SOUTH: {
                return this.rotate(90, 0, 0, center);
            }
        }
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec3d normalize() {
        Vec3d v = this.clone();
        double len = this.length();
        if (len == 0.0) {
            return v;
        }
        v.x /= len;
        v.y /= len;
        v.z /= len;
        return v;
    }

    public Vec3d abs() {
        return new Vec3d(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double dot(Vec3d v) {
        return this.x * v.getX() + this.y * v.getY() + this.z * v.getZ();
    }

    public Vec3d cross(Vec3d v) {
        return new Vec3d(this.y * v.getZ() - this.z * v.getY(), this.x * v.getZ() - this.z * v.getX(), this.x * v.getY() - this.y * v.getX());
    }

    public Vec3d getRelative(double x, double y, double z) {
        return this.clone().add(x, y, z);
    }

    public Vec3d getRelative(ForgeDirection dir) {
        return this.getRelative(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public ForgeDirection getDirectionTo(Vec3d vec) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getBlockX() + d.offsetX != vec.getBlockX() || this.getBlockY() + d.offsetY != vec.getBlockY() || this.getBlockZ() + d.offsetZ != vec.getBlockZ()) continue;
            return d;
        }
        return null;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vec3d clone() {
        return new Vec3d(this.x, this.y, this.z, this.w);
    }

    public boolean hasTileEntity() {
        if (this.hasWorld()) {
            return this.w.func_147438_o((int)this.x, (int)this.y, (int)this.z) != null;
        }
        return false;
    }

    public TileEntity getTileEntity() {
        if (this.hasTileEntity()) {
            return this.w.func_147438_o((int)this.x, (int)this.y, (int)this.z);
        }
        return null;
    }

    public boolean isBlock(Block b) {
        return this.isBlock(b, false);
    }

    public boolean isBlock(Block b, boolean checkAir) {
        if (this.hasWorld()) {
            Block bl = this.w.func_147439_a((int)this.x, (int)this.y, (int)this.z);
            if (b == null && bl == Blocks.field_150350_a) {
                return true;
            }
            if (b == null && checkAir && bl.func_149688_o() == Material.field_151579_a) {
                return true;
            }
            if (b == null && checkAir && bl.isAir((IBlockAccess)this.w, (int)this.x, (int)this.y, (int)this.z)) {
                return true;
            }
            return bl.getClass().isInstance(b);
        }
        return false;
    }

    public int getBlockMeta() {
        if (this.hasWorld()) {
            return this.w.func_72805_g((int)this.x, (int)this.y, (int)this.z);
        }
        return -1;
    }

    public Block getBlock() {
        return this.getBlock(false);
    }

    public Block getBlock(boolean airIsNull) {
        if (this.hasWorld()) {
            if (airIsNull && this.isBlock(null, true)) {
                return null;
            }
            return this.w.func_147439_a((int)this.x, (int)this.y, (int)this.z);
        }
        return null;
    }

    public World getWorld() {
        return this.w;
    }

    public Vec3d setWorld(World world) {
        this.w = world;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public Vec3d getImmutableCopy() {
        return new ImmutableVec3d(this);
    }

    public double distanceTo(Vec3d vec) {
        return this.distanceTo(vec.x, vec.y, vec.z);
    }

    public double distanceTo(double x, double y, double z) {
        double dx = x - this.x;
        double dy = y - this.y;
        double dz = z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public Vec3d set(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public Vec3d transform(Transformation transformation) {
        return transformation.apply(this);
    }

    public Vec2d getSide(ForgeDirection side) {
        switch (side) {
            case DOWN: 
            case UP: {
                return new Vec2d(this.getX(), this.getZ());
            }
            case NORTH: 
            case SOUTH: {
                return new Vec2d(this.getX(), this.getY());
            }
            case WEST: 
            case EAST: {
                return new Vec2d(this.getZ(), this.getY());
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec3d) {
            Vec3d vec = (Vec3d)obj;
            return vec.w == this.w && vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() + new Double(this.y).hashCode() << 8 + new Double(this.z).hashCode() << 16;
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        String s = "Vector3{";
        if (this.hasWorld()) {
            s = s + "w=" + this.w.field_73011_w.field_76574_g + ";";
        }
        s = s + "x=" + this.x + ";y=" + this.y + ";z=" + this.z + "}";
        return s;
    }

    public ForgeDirection toForgeDirection() {
        if (this.z == 1.0) {
            return ForgeDirection.SOUTH;
        }
        if (this.z == -1.0) {
            return ForgeDirection.NORTH;
        }
        if (this.x == 1.0) {
            return ForgeDirection.EAST;
        }
        if (this.x == -1.0) {
            return ForgeDirection.WEST;
        }
        if (this.y == 1.0) {
            return ForgeDirection.UP;
        }
        if (this.y == -1.0) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static Vec3d fromString(String s) {
        if (s.startsWith("Vector3{") && s.endsWith("}")) {
            World w = null;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            String s2 = s.substring(s.indexOf("{") + 1, s.lastIndexOf("}"));
            StringTokenizer st = new StringTokenizer(s2, ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.toLowerCase().startsWith("w")) {
                    int world = Integer.parseInt(t.split("=")[1]);
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        for (WorldServer wo : MinecraftServer.func_71276_C().field_71305_c) {
                            if (wo.field_73011_w.field_76574_g != world) continue;
                            w = wo;
                            break;
                        }
                    } else {
                        w = Vec3d.getClientWorld(world);
                    }
                }
                if (t.toLowerCase().startsWith("x")) {
                    x = Double.parseDouble(t.split("=")[1]);
                }
                if (t.toLowerCase().startsWith("y")) {
                    y = Double.parseDouble(t.split("=")[1]);
                }
                if (!t.toLowerCase().startsWith("z")) continue;
                z = Double.parseDouble(t.split("=")[1]);
            }
            if (w != null) {
                return new Vec3d(x, y, z, w);
            }
            return new Vec3d(x, y, z);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld(int world) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != world) {
            return null;
        }
        return Minecraft.func_71410_x().field_71441_e;
    }
}

