/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.block.BlockBase;
import uk.co.qmunity.lib.misc.ForgeDirectionUtils;
import uk.co.qmunity.lib.tile.IRotatable;
import uk.co.qmunity.lib.tile.TileBase;

public abstract class BlockTileBase
extends BlockBase
implements ITileEntityProvider {
    private int guiId = -1;
    private Class<? extends TileBase> tileEntityClass;
    private boolean isRedstoneEmitter;

    public BlockTileBase(Material material, Class<? extends TileBase> tileEntityClass) {
        super(material);
        this.field_149758_A = true;
        this.setTileEntityClass(tileEntityClass);
    }

    public BlockTileBase setGuiId(int guiId) {
        this.guiId = guiId;
        return this;
    }

    public int getGuiId() {
        return this.guiId;
    }

    public BlockTileBase setTileEntityClass(Class<? extends TileBase> tileEntityClass) {
        if (tileEntityClass == null) {
            throw new NullPointerException("Entity class can't be null!");
        }
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        try {
            return this.getTileEntity().newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class<? extends TileEntity> getTileEntity() {
        return this.tileEntityClass;
    }

    public BlockTileBase emitsRedstone() {
        this.isRedstoneEmitter = true;
        return this;
    }

    public boolean func_149744_f() {
        return this.isRedstoneEmitter;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileBase tileEntity;
        super.func_149695_a(world, x, y, z, block);
        if (!world.field_72995_K && (tileEntity = (TileBase)world.func_147438_o(x, y, z)) != null) {
            tileEntity.onBlockNeighbourChanged();
        }
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntity te = par1IBlockAccess.func_147438_o(par2, par3, par4);
        if (te instanceof TileBase) {
            TileBase tileBase = (TileBase)te;
            return tileBase.getOutputtingRedstone();
        }
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity == null || !(entity instanceof TileBase)) {
            return false;
        }
        if (this.getGuiId() >= 0) {
            if (!world.field_72995_K) {
                player.openGui(this.getModInstance(), this.getGuiId(), world, x, y, z);
            }
            return true;
        }
        return false;
    }

    protected abstract Object getModInstance();

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileBase tile;
        if (this.shouldDropItems() && (tile = (TileBase)world.func_147438_o(x, y, z)) != null) {
            for (ItemStack stack : tile.getDrops()) {
                BlockTileBase.spawnItemInWorld(world, stack, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    private static void spawnItemInWorld(World world, ItemStack itemStack, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j()));
        if (itemStack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        itemStack.field_77994_a = 0;
    }

    protected boolean shouldDropItems() {
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack iStack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IRotatable) {
            ((IRotatable)te).setFacingDirection(ForgeDirectionUtils.getDirectionFacing(player, this.canRotateVertical()).getOpposite());
        }
    }

    protected boolean canRotateVertical() {
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileEntity te = worldObj.func_147438_o(x, y, z);
        if (te instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)te;
            ForgeDirection dir = rotatable.getFacingDirection();
            if ((dir = dir.getRotation(axis)) != ForgeDirection.UP && dir != ForgeDirection.DOWN || this.canRotateVertical()) {
                rotatable.setFacingDirection(dir);
                return true;
            }
        }
        return false;
    }
}

