/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Consumer;
import java.util.function.Function;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class InputElement<T extends GuiScreen>
extends Element<T> {
    private String text;
    private boolean selected;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private int cursorCounter;
    private boolean editable = true;
    private Function<Integer, Boolean> allowKey;
    private Consumer<InputElement<T>> onEnter;

    public InputElement(T gui, String text, float posX, float posY, int width, Consumer<InputElement<T>> onEnter) {
        this(gui, text, posX, posY, width, true, onEnter, key -> true);
    }

    public InputElement(T gui, String text, float posX, float posY, int width, boolean editable, Consumer<InputElement<T>> onEnter, Function<Integer, Boolean> allowKey) {
        super(gui, posX, posY, width, 12);
        this.text = text != null ? text : "";
        this.editable = editable;
        this.onEnter = onEnter;
        this.allowKey = allowKey;
    }

    @Override
    public void update() {
        ++this.cursorCounter;
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight(), this.editable ? LLibrary.CONFIG.getSecondaryColor() : LLibrary.CONFIG.getSecondarySubcolor());
        int cursor = this.cursorPosition - this.lineScrollOffset;
        int cursorEnd = this.selectionEnd - this.lineScrollOffset;
        String displayString = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
        boolean verticalCursor = cursor >= 0 && cursor <= displayString.length();
        boolean renderCursor = this.selected && this.cursorCounter / 6 % 2 == 0 && verticalCursor;
        float x = this.getPosX();
        float y = this.getPosY();
        float line = x;
        if (cursorEnd > displayString.length()) {
            cursorEnd = displayString.length();
        }
        if (!displayString.isEmpty()) {
            String s = verticalCursor ? displayString.substring(0, cursor) : displayString;
            line = this.drawString(s, x + 3.0f, y + 1.0f + (float)(this.getHeight() / 2) - (float)(((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b / 2), LLibrary.CONFIG.getTextColor(), false);
        }
        boolean renderVerticalCursor = this.cursorPosition < this.text.length();
        float lineX = line;
        if (!verticalCursor) {
            lineX = cursor > 0 ? x + (float)this.getWidth() : x;
        } else if (renderVerticalCursor) {
            lineX = line - 1.0f;
            line -= 1.0f;
        }
        if (!displayString.isEmpty() && verticalCursor && cursor < displayString.length()) {
            this.drawString(displayString.substring(cursor), line + 1.0f, y + 1.0f + (float)(this.getHeight() / 2) - (float)(((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b / 2), LLibrary.CONFIG.getTextColor(), false);
        }
        if (renderCursor) {
            if (renderVerticalCursor) {
                this.drawRectangle(lineX, y, 1.0, this.getHeight() / 2 - ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b / 2 + 1 + ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b, LLibrary.CONFIG.getPrimaryColor());
            } else {
                this.drawString("_", cursor == 0 ? lineX + 3.0f : lineX, y + 1.0f + (float)(this.getHeight() / 2) - (float)(((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b / 2), LLibrary.CONFIG.getPrimaryColor(), false);
            }
        }
        if (cursorEnd != cursor) {
            float selectionWidth = x + (float)((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.func_78256_a(displayString.substring(0, cursorEnd));
            this.drawCursorVertical(lineX + (float)(this.selectionEnd <= this.cursorPosition ? 1 : 0), y, selectionWidth + (float)(this.selectionEnd < this.cursorPosition ? 2 : 3), y + (float)(this.getHeight() / 2) - (float)(((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b / 2) + 1.0f + (float)((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.field_78288_b);
        }
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        boolean newSelected = this.isMouseSelecting(mouseX, mouseY);
        if (!newSelected && this.selected) {
            this.onEnter.accept(this);
        }
        this.selected = newSelected;
        if (this.selected && button == 0 && this.editable) {
            int width = (int)(mouseX - this.getPosX() - 1.0f);
            String displayString = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
            this.setCursorPosition(((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.func_78269_a(displayString, width).length() + this.lineScrollOffset);
        }
        return false;
    }

    @Override
    public boolean keyPressed(char character, int key) {
        if (!this.selected) {
            return false;
        }
        if (ClientUtils.isKeyComboCtrlA(key)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (ClientUtils.isKeyComboCtrlC(key)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (ClientUtils.isKeyComboCtrlV(key)) {
            this.writeText(GuiScreen.func_146277_j());
            return true;
        }
        if (ClientUtils.isKeyComboCtrlX(key)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            this.writeText("");
            return true;
        }
        if (key == 28) {
            this.onEnter.accept(this);
            return true;
        }
        switch (key) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    this.deleteWords(-1);
                } else {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selectionEnd));
                    } else {
                        this.setSelectionPos(this.selectionEnd + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    this.deleteWords(1);
                } else {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)character) && this.allowKey.apply(key).booleanValue()) {
            this.writeText(Character.toString(character));
            return true;
        }
        return false;
    }

    private boolean isMouseSelecting(float mouseX, float mouseY) {
        return mouseX >= this.getPosX() && mouseX < this.getPosX() + (float)this.getWidth() && mouseY >= this.getPosY() && mouseY < this.getPosY() + (float)this.getHeight();
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int start = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int end = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(start, end);
    }

    public void writeText(String text) {
        int end;
        String newText = "";
        String allowedText = ChatAllowedCharacters.func_71565_a((String)text);
        int start = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int n = end = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        if (!this.text.isEmpty()) {
            newText = newText + this.text.substring(0, start);
        }
        newText = newText + allowedText;
        if (!this.text.isEmpty() && end < this.text.length()) {
            newText = newText + this.text.substring(end);
        }
        this.text = newText;
        this.moveCursorBy(start - this.selectionEnd + allowedText.length());
    }

    public void deleteWords(int amount) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(amount) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int amount) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean delete = amount < 0;
                int start = delete ? this.cursorPosition + amount : this.cursorPosition;
                int end = delete ? this.cursorPosition : this.cursorPosition + amount;
                String nextText = "";
                if (start >= 0) {
                    nextText = this.text.substring(0, start);
                }
                if (end < this.text.length()) {
                    nextText = nextText + this.text.substring(end);
                }
                this.text = nextText;
                if (delete) {
                    this.moveCursorBy(amount);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    public int getNthWordFromPos(int n, int position) {
        return this.getNthWordFromPosWhitespace(n, position, true);
    }

    public int getNthWordFromPosWhitespace(int n, int position, boolean skipWhitespace) {
        int currentPos = position;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((currentPos = this.text.indexOf(32, currentPos)) == -1) {
                    currentPos = l;
                    continue;
                }
                while (skipWhitespace && currentPos < l && this.text.charAt(currentPos) == ' ') {
                    ++currentPos;
                }
                continue;
            }
            while (skipWhitespace && currentPos > 0 && this.text.charAt(currentPos - 1) == ' ') {
                --currentPos;
            }
            while (currentPos > 0 && this.text.charAt(currentPos - 1) != ' ') {
                --currentPos;
            }
        }
        return currentPos;
    }

    public void moveCursorBy(int amount) {
        this.setCursorPosition(this.selectionEnd + amount);
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = position;
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public void setSelectionPos(int position) {
        int textLength = this.text.length();
        if (position > textLength) {
            position = textLength;
        } else if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.lineScrollOffset > textLength) {
            this.lineScrollOffset = textLength;
        }
        String displayText = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.func_78269_a(this.text.substring(this.lineScrollOffset), this.getWidth());
        int offset = displayText.length() + this.lineScrollOffset;
        if (position == this.lineScrollOffset) {
            this.lineScrollOffset -= ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p.func_78262_a(this.text, this.getWidth(), true).length();
        }
        if (position > offset) {
            this.lineScrollOffset += position - offset;
        } else if (position <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - position;
        }
        this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)textLength);
    }

    public void clearText() {
        this.setCursorPositionZero();
        this.text = "";
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private void drawCursorVertical(float startX, float startY, float endX, float endY) {
        if (startX < endX) {
            float prevStartX = startX;
            startX = endX;
            endX = prevStartX;
        }
        if (startY < endY) {
            float prevStartY = startY;
            startY = endY;
            endY = prevStartY;
        }
        if (endX > this.getPosX() + (float)this.getWidth()) {
            endX = this.getPosY() + (float)this.getWidth();
        }
        if (startX > this.getPosX() + (float)this.getWidth()) {
            startX = this.getPosY() + (float)this.getWidth();
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)startX, (double)endY, 0.0);
        tessellator.func_78377_a((double)endX, (double)endY, 0.0);
        tessellator.func_78377_a((double)endX, (double)startY, 0.0);
        tessellator.func_78377_a((double)startX, (double)startY, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }
}

