/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MantlePulsarHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TinkerBlockHandler
extends ModHandlerBase {
    private static final TinkerBlockHandler instance = new TinkerBlockHandler();
    private final Object pulsar;
    public final Block gravelOreID;
    public final Block stoneOreID;
    public final Block clearGlassID;
    public final Block clearPaneID;
    private final Item materialID;
    public final Block searedBlockID;
    public final Block smelteryTankID;
    public final Block smelteryBlockID;
    public final Block netherSmelteryID;
    public final Block netherTankID;
    public final BlockKey slimeDirt;
    public final BlockKey slimeGrass;
    public final Block slimeWater;
    public final Block congealedSlime;
    public final Block slimeTallGrass;

    private TinkerBlockHandler() {
        Block idgravel = null;
        Block idnether = null;
        Block idglass = null;
        Block idpane = null;
        Item idmaterial = null;
        Object pulse = null;
        Block idseared = null;
        Block idtank = null;
        Block idsmelt = null;
        Block idtanknether = null;
        Block idsmeltnether = null;
        if (this.hasMod()) {
            Class<?> tink;
            try {
                Class<?> c = Class.forName("tconstruct.TConstruct");
                Field p = c.getField("pulsar");
                pulse = p.get(null);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            try {
                tink = ModList.TINKERER.getBlockClass();
                Field gravel = tink.getField("oreGravel");
                idgravel = (Block)gravel.get(null);
                Field ore = tink.getField("oreSlag");
                idnether = (Block)gravel.get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            try {
                tink = Class.forName("tconstruct.smeltery.TinkerSmeltery");
                Field glass = tink.getField("clearGlass");
                idglass = (Block)glass.get(null);
                Field pane = tink.getField("glassPane");
                idpane = (Block)pane.get(null);
                Field sear = tink.getField("searedBlock");
                idseared = (Block)sear.get(null);
                Field tank = tink.getField("lavaTank");
                idtank = (Block)tank.get(null);
                Field smelt = tink.getField("smeltery");
                idsmelt = (Block)smelt.get(null);
                Field tanknether = tink.getField("lavaTankNether");
                idtanknether = (Block)tanknether.get(null);
                Field smeltnether = tink.getField("smelteryNether");
                idsmeltnether = (Block)smeltnether.get(null);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            try {
                Class<?> tic = Class.forName("tconstruct.tools.TinkerTools");
                Field mat = tic.getField("materials");
                idmaterial = (Item)mat.get(null);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
            this.slimeDirt = new BlockKey(ReikaItemHelper.lookupBlock(this.getMod(), "CraftedSoil", 5));
            this.slimeGrass = new BlockKey(ReikaItemHelper.lookupBlock(this.getMod(), "slime.grass", 5));
            this.congealedSlime = GameRegistry.findBlock((String)this.getMod().modLabel, (String)"slime.gel");
            this.slimeWater = GameRegistry.findBlock((String)this.getMod().modLabel, (String)"liquid.slime");
            this.slimeTallGrass = GameRegistry.findBlock((String)this.getMod().modLabel, (String)"slime.grass.tall");
        } else {
            this.noMod();
            this.slimeDirt = null;
            this.slimeGrass = null;
            this.congealedSlime = null;
            this.slimeWater = null;
            this.slimeTallGrass = null;
        }
        this.pulsar = pulse;
        this.gravelOreID = idgravel;
        this.stoneOreID = idnether;
        this.clearGlassID = idglass;
        this.clearPaneID = idpane;
        this.searedBlockID = idseared;
        this.smelteryBlockID = idsmelt;
        this.smelteryTankID = idtank;
        this.netherSmelteryID = idsmeltnether;
        this.netherTankID = idtanknether;
        this.materialID = idmaterial;
    }

    public static TinkerBlockHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.gravelOreID != null && this.stoneOreID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.TINKERER;
    }

    public boolean isGravelOre(ItemStack block) {
        if (!this.initializedProperly()) {
            return false;
        }
        return Block.func_149634_a((Item)block.func_77973_b()) == this.gravelOreID;
    }

    public boolean isNetherOre(ItemStack block) {
        if (!this.initializedProperly()) {
            return false;
        }
        return Block.func_149634_a((Item)block.func_77973_b()) == this.stoneOreID && block.func_77960_j() < 3;
    }

    public boolean isSlimeIslandBlock(Block b, int meta) {
        if (this.slimeDirt.match(b, meta) || this.slimeGrass.match(b, meta) || b == this.slimeWater || b == this.slimeTallGrass || b == this.congealedSlime) {
            return true;
        }
        return ModWoodList.getModWood(b, meta) == ModWoodList.SLIME || ModWoodList.getModWoodFromLeaf(b, meta) == ModWoodList.SLIME;
    }

    public boolean isSmelteryBlock(Block b) {
        return b == this.smelteryBlockID || b == this.smelteryTankID || b == this.netherSmelteryID || b == this.netherTankID;
    }

    public static enum Pulses {
        SMELTERY("Tinkers' Smeltery"),
        TOOLS("Tinkers' Tools"),
        WEAPONS("Tinkers' Weaponry"),
        ARMOR("Tinkers' Armory"),
        MECH("Tinkers' Mechworks"),
        WORLD("Tinkers' World");

        private final String id;

        private Pulses(String s) {
            this.id = s;
        }

        public boolean isLoaded() {
            return MantlePulsarHandler.isPulseLoaded(instance.pulsar, this.id);
        }
    }

    public static enum SmelteryTanks {
        TANK(0),
        GLASS(1),
        WINDOW(2);

        public final int metadata;
        public static final SmelteryTanks[] list;

        private SmelteryTanks(int meta) {
            this.metadata = meta;
        }

        public ItemStack getItem(boolean nether) {
            return new ItemStack(nether ? instance.netherTankID : instance.smelteryTankID, 1, this.metadata);
        }

        static {
            list = SmelteryTanks.values();
        }
    }

    public static enum SmelteryBlocks {
        CONTROLLER,
        DRAIN,
        BRICK,
        NONE,
        STONE,
        COBBLE,
        PAVER,
        CRACKED,
        ROAD,
        FANCY,
        CHISELED,
        CREEPER;

        public static final SmelteryBlocks[] list;

        public ItemStack getItem(boolean nether) {
            return new ItemStack(nether ? instance.netherSmelteryID : instance.smelteryBlockID, 1, this.ordinal());
        }

        public boolean isBasicBuildingBlock() {
            switch (this) {
                case CONTROLLER: 
                case DRAIN: {
                    return false;
                }
            }
            return true;
        }

        static {
            list = SmelteryBlocks.values();
        }
    }

    public static enum Materials {
        SLIMECRYSTAL(1),
        SEAREDBRICK(2),
        MOSSBALL(6),
        LAVACRYSTAL(7),
        NECROTICBONE(8),
        SLIMECRYSTAL2(17),
        SILKYCLOTH(25),
        SILKYJEWEL(26),
        GLUE(36),
        NETHERBRICK(37);

        private final int metadata;

        private Materials(int m) {
            this.metadata = m;
        }

        public ItemStack getItem() {
            return new ItemStack(instance.materialID, 1, this.metadata);
        }
    }
}

