/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class OreBerryBushHandler
extends CropHandlerBase {
    private static final OreBerryBushHandler instance = new OreBerryBushHandler();
    public final Block bushID;
    public final Block secondbushID;
    public final Item berryID;

    private OreBerryBushHandler() {
        Block idbush = null;
        Block idsecondbush = null;
        Item idberry = null;
        if (this.hasMod()) {
            Class blocks = this.getMod().getBlockClass();
            Class items = this.getMod().getItemClass();
            try {
                Item berry;
                Block secondbush;
                Block bush;
                Field f = blocks.getField("oreBerry");
                idbush = bush = (Block)f.get(null);
                f = blocks.getField("oreBerrySecond");
                idsecondbush = secondbush = (Block)f.get(null);
                f = items.getField("oreBerries");
                idberry = berry = (Item)f.get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.berryID = idberry;
        this.bushID = idbush;
        this.secondbushID = idsecondbush;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == this.bushID || id == this.secondbushID;
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return false;
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        return this.isCrop(b, meta = world.func_72805_g(x, y, z)) && meta >= 12;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int base = meta % 4;
        int metato = 12 + base;
        world.func_72921_c(x, y, z, metato, 3);
    }

    public static OreBerryBushHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.bushID != null && this.berryID != null || this.secondbushID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.TINKERER;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) - 4;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (id == this.bushID) {
            li.add(new ItemStack(this.berryID, 1 + this.rand.nextInt(3), meta % 4));
        } else if (id == this.secondbushID) {
            li.add(new ItemStack(this.berryID, 1 + this.rand.nextInt(3), meta % 4 + 4));
        }
        return li;
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) % 4;
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return true;
    }

    public static enum BerryTypes {
        IRON,
        GOLD,
        COPPER,
        TIN,
        ALUMINUM,
        XP;


        public ItemStack getStack() {
            return new ItemStack(instance.berryID, 1, this.ordinal());
        }

        public BlockKey getBush() {
            Block b = this == ALUMINUM || this == XP ? instance.secondbushID : instance.bushID;
            int meta = 12 + this.ordinal();
            if (b == instance.secondbushID) {
                meta -= ALUMINUM.ordinal();
            }
            return new BlockKey(b, meta);
        }
    }
}

