/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public final class ReikaAABBHelper
extends DragonAPICore {
    @SideOnly(value=Side.CLIENT)
    public static void renderAABB(AxisAlignedBB box, double par2, double par4, double par6, int x, int y, int z, int a, int r, int g, int b, boolean line) {
        int[] color = new int[]{r, g, b, a};
        ReikaRenderHelper.prepareGeoDraw(true);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        if (color[3] > 255 && color[3] > 0) {
            color[3] = 255;
        }
        if (color[3] < 0) {
            color[3] = color[3] * -1;
        }
        boolean filled = true;
        Tessellator var5 = Tessellator.field_78398_a;
        double xdiff = box.field_72340_a - (double)x;
        double ydiff = box.field_72338_b - (double)y;
        double zdiff = box.field_72339_c - (double)z;
        double xdiff2 = box.field_72336_d - (double)x;
        double ydiff2 = box.field_72337_e - (double)y;
        double zdiff2 = box.field_72334_f - (double)z;
        double px = par2 + xdiff;
        double py = par4 + ydiff;
        double pz = par6 + zdiff;
        double px2 = par2 + xdiff2;
        double py2 = par4 + ydiff2;
        double pz2 = par6 + zdiff2;
        if (var5.field_78415_z) {
            var5.func_78381_a();
        }
        if (line) {
            var5.func_78371_b(2);
            var5.func_78370_a(color[0], color[1], color[2], color[3]);
            var5.func_78377_a(px2, py2, pz);
            var5.func_78377_a(px, py2, pz);
            var5.func_78377_a(px, py2, pz2);
            var5.func_78377_a(px2, py2, pz2);
            var5.func_78381_a();
            var5.func_78371_b(2);
            var5.func_78370_a(color[0], color[1], color[2], color[3]);
            var5.func_78377_a(px2, py, pz);
            var5.func_78377_a(px, py, pz);
            var5.func_78377_a(px, py, pz2);
            var5.func_78377_a(px2, py, pz2);
            var5.func_78381_a();
            var5.func_78371_b(2);
            var5.func_78370_a(color[0], color[1], color[2], color[3]);
            var5.func_78377_a(px, py, pz);
            var5.func_78377_a(px, py2, pz);
            var5.func_78381_a();
            var5.func_78371_b(2);
            var5.func_78370_a(color[0], color[1], color[2], color[3]);
            var5.func_78377_a(px2, py, pz);
            var5.func_78377_a(px2, py2, pz);
            var5.func_78381_a();
            var5.func_78371_b(2);
            var5.func_78370_a(color[0], color[1], color[2], color[3]);
            var5.func_78377_a(px2, py, pz2);
            var5.func_78377_a(px2, py2, pz2);
            var5.func_78381_a();
            var5.func_78371_b(2);
            var5.func_78370_a(color[0], color[1], color[2], color[3]);
            var5.func_78377_a(px, py, pz2);
            var5.func_78377_a(px, py2, pz2);
            var5.func_78381_a();
        }
        if (filled) {
            var5.func_78371_b(7);
            var5.func_78370_a(color[0], color[1], color[2], (int)((float)color[3] * 0.375f));
            var5.func_78377_a(px, py, pz);
            var5.func_78377_a(px2, py, pz);
            var5.func_78377_a(px2, py, pz2);
            var5.func_78377_a(px, py, pz2);
            var5.func_78377_a(px2, py, pz);
            var5.func_78377_a(px2, py2, pz);
            var5.func_78377_a(px2, py2, pz2);
            var5.func_78377_a(px2, py, pz2);
            var5.func_78377_a(px, py2, pz);
            var5.func_78377_a(px, py, pz);
            var5.func_78377_a(px, py, pz2);
            var5.func_78377_a(px, py2, pz2);
            var5.func_78377_a(px, py2, pz2);
            var5.func_78377_a(px, py, pz2);
            var5.func_78377_a(px2, py, pz2);
            var5.func_78377_a(px2, py2, pz2);
            var5.func_78377_a(px, py, pz);
            var5.func_78377_a(px, py2, pz);
            var5.func_78377_a(px2, py2, pz);
            var5.func_78377_a(px2, py, pz);
            var5.func_78377_a(px2, py2, pz);
            var5.func_78377_a(px, py2, pz);
            var5.func_78377_a(px, py2, pz2);
            var5.func_78377_a(px2, py2, pz2);
            var5.func_78381_a();
        }
        ReikaRenderHelper.exitGeoDraw();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
    }

    public static AxisAlignedBB getBlockAABB(TileEntity te) {
        return ReikaAABBHelper.getBlockAABB(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static AxisAlignedBB getBlockAABB(int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public static AxisAlignedBB getZeroAABB() {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public static AxisAlignedBB getBlockCenteredAABB(int x, int y, int z, double range) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(range, range, range);
    }

    public static AxisAlignedBB getEntityCenteredAABB(Entity e, double range) {
        return AxisAlignedBB.func_72330_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v, (double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v).func_72314_b(range, range, range);
    }

    public static AxisAlignedBB getSizedBlockAABB(int x, int y, int z, float size) {
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - (double)(size /= 2.0f)), (double)((double)y + 0.5 - (double)size), (double)((double)z + 0.5 - (double)size), (double)((double)x + 0.5 + (double)size), (double)((double)y + 0.5 + (double)size), (double)((double)z + 0.5 + (double)size));
    }

    public static HashSet<Coordinate> getBlocksIntersectingAABB(AxisAlignedBB box, World world, boolean checkCollideable) {
        HashSet<Coordinate> c = new HashSet<Coordinate>();
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int minY = MathHelper.func_76128_c((double)box.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)box.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)box.field_72337_e);
        int maxZ = MathHelper.func_76128_c((double)box.field_72334_f);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = world.func_147439_a(x, y, z);
                    int meta = world.func_72805_g(x, y, z);
                    if (checkCollideable && (!b.func_149703_v() || !b.func_149678_a(meta, false)) || x == minX && box.field_72340_a >= (double)x + b.func_149753_y() || x == maxX && box.field_72336_d <= (double)x + b.func_149704_x() || y == minY && box.field_72338_b >= (double)y + b.func_149669_A() || y == maxY && box.field_72337_e <= (double)y + b.func_149665_z() || z == minZ && box.field_72339_c >= (double)z + b.func_149693_C() || z == maxZ && box.field_72334_f <= (double)z + b.func_149706_B()) continue;
                    c.add(new Coordinate(x, y, z));
                }
            }
        }
        return c;
    }

    public static double getVolume(AxisAlignedBB box) {
        return (box.field_72336_d - box.field_72340_a) * (box.field_72337_e - box.field_72338_b) * (box.field_72334_f - box.field_72339_c);
    }

    public static AxisAlignedBB structureToAABB(StructureBoundingBox box) {
        return AxisAlignedBB.func_72330_a((double)box.field_78897_a, (double)box.field_78895_b, (double)box.field_78896_c, (double)box.field_78893_d, (double)box.field_78894_e, (double)box.field_78892_f);
    }

    public static AxisAlignedBB getBeamBox(int x, int y, int z, ForgeDirection dir, int dist) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB(x, y, z);
        int dx = dir.offsetX * dist;
        int dy = dir.offsetY * dist;
        int dz = dir.offsetZ * dist;
        box = box.func_72321_a((double)dx, (double)dy, (double)dz);
        return box;
    }

    public static AxisAlignedBB getBeamBox(int x, int y, int z, ForgeDirection dir, int d1, int d2) {
        int x1 = x + dir.offsetX * d1;
        int y1 = y + dir.offsetY * d1;
        int z1 = z + dir.offsetZ * d1;
        int x2 = dir.offsetX * d2;
        int y2 = dir.offsetY * d2;
        int z2 = dir.offsetZ * d2;
        return ReikaAABBHelper.getBeamBox(x1, y1, z1, x2, y2, z2);
    }

    public static AxisAlignedBB getBeamBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        return ReikaAABBHelper.getBlockAABB(x1, y1, z1).func_72321_a((double)x2, (double)y2, (double)z2);
    }

    public static AxisAlignedBB copyAABB(AxisAlignedBB box) {
        return AxisAlignedBB.func_72330_a((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c, (double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
    }

    public static AxisAlignedBB fromPoints(DecimalPosition ... points) {
        double[] limits = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < points.length; ++i) {
            limits[0] = Math.min(limits[0], points[i].xCoord);
            limits[1] = Math.min(limits[1], points[i].yCoord);
            limits[2] = Math.min(limits[2], points[i].zCoord);
            limits[3] = Math.max(limits[3], points[i].xCoord);
            limits[4] = Math.max(limits[4], points[i].yCoord);
            limits[5] = Math.max(limits[5], points[i].zCoord);
        }
        return AxisAlignedBB.func_72330_a((double)limits[0], (double)limits[1], (double)limits[2], (double)limits[3], (double)limits[4], (double)limits[5]);
    }

    public static AxisAlignedBB scaleAABB(AxisAlignedBB box, double sx, double sy, double sz) {
        double dx = (sx - 1.0) * (box.field_72336_d - box.field_72340_a);
        double dy = (sy - 1.0) * (box.field_72337_e - box.field_72338_b);
        double dz = (sz - 1.0) * (box.field_72334_f - box.field_72339_c);
        return box.func_72314_b(dx, dy, dz);
    }

    public static void compressAABB(AxisAlignedBB box, double dx, double dy, double dz) {
        box.field_72340_a += dx;
        box.field_72338_b += dy;
        box.field_72339_c += dz;
        box.field_72336_d -= dx;
        box.field_72337_e -= dy;
        box.field_72334_f -= dz;
    }

    public static void fillAABB(AxisAlignedBB box, int nx, int ny, int nz, int mx, int my, int mz) {
        box.field_72336_d = Math.max(box.field_72336_d, (double)mx);
        box.field_72337_e = Math.max(box.field_72337_e, (double)my);
        box.field_72334_f = Math.max(box.field_72334_f, (double)mz);
        box.field_72340_a = Math.min(box.field_72340_a, (double)nx);
        box.field_72338_b = Math.min(box.field_72338_b, (double)ny);
        box.field_72339_c = Math.min(box.field_72339_c, (double)nz);
    }
}

