/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

public enum ReikaTimeHelper {
    YEAR(630720000, "y"),
    MONTH(51840000, "mo"),
    WEEK(12096000, "w"),
    DAY(1728000, "d"),
    HOUR(72000, "h"),
    MINUTE(1200, "m"),
    SECOND(20, "s"),
    TICK(1, "t");

    private int time;
    private String abbrev;

    private ReikaTimeHelper(int t, String a) {
        this.time = t;
        this.abbrev = a;
    }

    public double getNumberOf(ReikaTimeHelper time) {
        return this.getDuration() / time.getDuration();
    }

    public int getDuration() {
        return this.time;
    }

    public int getMinecraftDuration() {
        switch (this) {
            case DAY: {
                return this.time / 72;
            }
            case HOUR: {
                return this.time / 144;
            }
            case MONTH: {
                return DAY.getMinecraftDuration() * 8;
            }
            case WEEK: {
                return DAY.getMinecraftDuration() * 2;
            }
            case YEAR: {
                return MONTH.getMinecraftDuration() * 6;
            }
        }
        return this.time;
    }

    public String getAbbreviation() {
        return this.abbrev;
    }
}

