/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;

public class RGBColorData {
    public boolean red;
    public boolean green;
    public boolean blue;

    public RGBColorData(boolean red, boolean green, boolean blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void intersect(RGBColorData dat) {
        this.red = this.red && dat.red;
        this.green = this.green && dat.green;
        this.blue = this.blue && dat.blue;
    }

    public void add(RGBColorData dat) {
        this.red = this.red || dat.red;
        this.green = this.green || dat.green;
        this.blue = this.blue || dat.blue;
    }

    public void invert() {
        this.red = !this.red;
        this.green = !this.green;
        this.blue = !this.blue;
    }

    public boolean isBlack() {
        return !this.red && !this.green && !this.blue;
    }

    public boolean isWhite() {
        return this.red && this.green && this.blue;
    }

    public boolean isPrimary() {
        int c = 0;
        if (this.red) {
            ++c;
        }
        if (this.green) {
            ++c;
        }
        if (this.blue) {
            ++c;
        }
        return c == 1;
    }

    public boolean matchColor(RGBColorData o) {
        return o.red == this.red && o.green == this.green && o.blue == this.blue;
    }

    public int getRenderColor() {
        return this.isBlack() ? 0x101010 : ReikaColorAPI.RGBtoHex(this.red ? 255 : 0, this.green ? 255 : 0, this.blue ? 255 : 0);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.red = tag.func_74767_n("red");
        this.green = tag.func_74767_n("green");
        this.blue = tag.func_74767_n("blue");
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("red", this.red);
        tag.func_74757_a("green", this.green);
        tag.func_74757_a("blue", this.blue);
    }

    public void writeBuf(ByteBuf data) {
        data.writeBoolean(this.red);
        data.writeBoolean(this.green);
        data.writeBoolean(this.blue);
    }

    public void readBuf(ByteBuf data) {
        this.red = data.readBoolean();
        this.green = data.readBoolean();
        this.blue = data.readBoolean();
    }

    public boolean equals(Object o) {
        return o instanceof RGBColorData && this.matchColor((RGBColorData)o);
    }

    public int hashCode() {
        return this.getRenderColor();
    }

    public RGBColorData copy() {
        return new RGBColorData(this.red, this.green, this.blue);
    }

    public String toString() {
        return this.getName() + ": " + this.red + "/" + this.green + "/" + this.blue + " : " + Integer.toHexString(this.getRenderColor() & 0xFFFFFF);
    }

    public String getName() {
        if (this.red) {
            if (this.green) {
                if (this.blue) {
                    return "white";
                }
                return "yellow";
            }
            if (this.blue) {
                return "magenta";
            }
            return "red";
        }
        if (this.green) {
            if (this.blue) {
                return "cyan";
            }
            return "green";
        }
        if (this.blue) {
            return "blue";
        }
        return "black";
    }

    public Collection<RGBColorData> getReductiveChildren(boolean allowSelf, boolean allowBlack) {
        Collection<RGBColorData> ret = this.getAllPossibilities();
        Iterator<RGBColorData> it = ret.iterator();
        while (it.hasNext()) {
            RGBColorData c = it.next();
            if (c.matchColor(this) && !allowSelf) {
                it.remove();
                continue;
            }
            if (c.isBlack() && !allowBlack) {
                it.remove();
                continue;
            }
            if (!this.red && c.red) {
                it.remove();
                continue;
            }
            if (!this.green && c.green) {
                it.remove();
                continue;
            }
            if (this.blue || !c.blue) continue;
            it.remove();
        }
        return ret;
    }

    public Collection<RGBColorData> getAdditiveChildren(boolean allowSelf, boolean allowWhite) {
        Collection<RGBColorData> ret = this.getAllPossibilities();
        Iterator<RGBColorData> it = ret.iterator();
        while (it.hasNext()) {
            RGBColorData c = it.next();
            if (c.matchColor(this) && !allowSelf) {
                it.remove();
                continue;
            }
            if (c.isWhite() && !allowWhite) {
                it.remove();
                continue;
            }
            if (this.red && !c.red) {
                it.remove();
                continue;
            }
            if (this.green && !c.green) {
                it.remove();
                continue;
            }
            if (!this.blue || c.blue) continue;
            it.remove();
        }
        return ret;
    }

    public RGBColorData getColorNeededToMake(RGBColorData c) {
        RGBColorData c2 = this.copy();
        c2.invert();
        c2.add(c);
        return c2;
    }

    public static RGBColorData white() {
        return new RGBColorData(true, true, true);
    }

    public static RGBColorData black() {
        return new RGBColorData(false, false, false);
    }

    public static RGBColorData fromHex(int hex) {
        int r = ReikaColorAPI.getRed(hex);
        int g = ReikaColorAPI.getGreen(hex);
        int b = ReikaColorAPI.getBlue(hex);
        return new RGBColorData(r > 127, g > 127, b > 127);
    }

    public static Collection<RGBColorData> getAllPossibilities() {
        ArrayList<RGBColorData> ret = new ArrayList<RGBColorData>();
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 1; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    ret.add(new RGBColorData(i > 0, j > 0, k > 0));
                }
            }
        }
        return ret;
    }
}

