/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Exception.MisuseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PrimeFinder {
    private long countLimit;
    private final ArrayList<Long> primes;
    private final HashSet<Long> primeSet;

    public PrimeFinder(long limit) {
        this.countLimit = limit;
        int cap = (int)Math.sqrt(limit);
        this.primeSet = new HashSet(cap, 0.5f);
        this.primes = new ArrayList(cap);
        this.calculateFrom(3L, limit);
    }

    public void expandTo(long limit) {
        this.calculateFrom(this.countLimit, limit);
        this.countLimit = limit;
    }

    private void calculateFrom(long low, long hi) {
        if (low % 2L == 0L) {
            ++low;
        }
        if (hi % 2L == 0L) {
            --hi;
        }
        for (long val = low; val <= hi; val += 2L) {
            if (!this.evaluate(val)) continue;
            this.primes.add(val);
            this.primeSet.add(val);
        }
    }

    private boolean evaluate(long val) {
        if (val < 3L) {
            return false;
        }
        if ((val & 1L) == 0L) {
            return false;
        }
        return this.checkPrimesDivision(val);
    }

    private boolean checkPrimesDivision(long val) {
        for (long p : this.primes) {
            if (val % p == 0L) {
                return false;
            }
            if (!((double)p >= Math.sqrt(val))) continue;
            break;
        }
        return true;
    }

    public boolean isPrime(long val) {
        if ((val = Math.abs(val)) > this.countLimit) {
            throw new MisuseException("You cannot query values larger than the calculated range!");
        }
        return this.primeSet.contains(val);
    }

    public List<Long> getPrimes() {
        return Collections.unmodifiableList(this.primes);
    }
}

