/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Instantiable.Math.DoubleRectangle;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class DoublePolygon {
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    protected DoubleRectangle bounds;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;

    public DoublePolygon() {
        this.xpoints = new double[4];
        this.ypoints = new double[4];
    }

    public DoublePolygon(double[] xpoints, double[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        if (npoints < 0) {
            throw new NegativeArraySizeException("npoints < 0");
        }
        this.npoints = npoints;
        this.xpoints = Arrays.copyOf(xpoints, npoints);
        this.ypoints = Arrays.copyOf(ypoints, npoints);
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void translate(int deltaX, int deltaY) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + (double)deltaX;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + (double)deltaY;
        }
        if (this.bounds != null) {
            this.bounds.translate(deltaX, deltaY);
        }
    }

    void calculateBounds(double[] xpoints, double[] ypoints, int npoints) {
        double boundsMinX = Double.POSITIVE_INFINITY;
        double boundsMinY = Double.POSITIVE_INFINITY;
        double boundsMaxX = Double.NEGATIVE_INFINITY;
        double boundsMaxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < npoints; ++i) {
            double x = xpoints[i];
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            double y = ypoints[i];
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        this.bounds = new DoubleRectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    void updateBounds(double x, double y) {
        if (x < this.bounds.x) {
            this.bounds.width += this.bounds.x - x;
            this.bounds.x = x;
        } else {
            this.bounds.width = Math.max(this.bounds.width, x - this.bounds.x);
        }
        if (y < this.bounds.y) {
            this.bounds.height += this.bounds.y - y;
            this.bounds.y = y;
        } else {
            this.bounds.height = Math.max(this.bounds.height, y - this.bounds.y);
        }
    }

    public void addPoint(double x, double y) {
        if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
            int newLength = this.npoints * 2;
            if (newLength < 4) {
                newLength = 4;
            } else if ((newLength & newLength - 1) != 0) {
                newLength = Integer.highestOneBit(newLength);
            }
            this.xpoints = Arrays.copyOf(this.xpoints, newLength);
            this.ypoints = Arrays.copyOf(this.ypoints, newLength);
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(x, y);
        }
    }

    public DoubleRectangle getBounds() {
        return this.getBoundingBox();
    }

    @Deprecated
    public DoubleRectangle getBoundingBox() {
        if (this.npoints == 0) {
            return new DoubleRectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    @Deprecated
    public boolean inside(double x, double y) {
        return this.contains(x, y);
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(x, y)) {
            return false;
        }
        hits = 0;
        lastx = this.xpoints[this.npoints - 1];
        lasty = this.ypoints[this.npoints - 1];
        for (i = 0; i < this.npoints; ++i) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = this.xpoints[i];
                                cury = this.ypoints[i];
                                if (cury == lasty) break block8;
                                if (!(curx < lastx)) break block9;
                                if (x >= lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= curx) break block8;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block11;
                        if (y < cury || y >= lasty) break block8;
                        if (!(x < leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl34
                }
                if (y < lasty || y >= cury) break block8;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl34:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolygonPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class PolygonPathIterator
    implements PathIterator {
        DoublePolygon poly;
        AffineTransform transform;
        int index;

        public PolygonPathIterator(DoublePolygon pg, AffineTransform at) {
            this.poly = pg;
            this.transform = at;
            if (pg.npoints == 0) {
                this.index = 1;
            }
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = (float)this.poly.xpoints[this.index];
            coords[1] = (float)this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

