/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.IO.ReikaXMLBase;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.DataProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.util.EnumChatFormatting;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLInterface {
    private Document doc;
    private final boolean requireFile;
    private final LoadPoint loadData;
    private final LoadFormat format;
    private final String pathString;
    private Class referenceClass;
    private boolean isEncrypted;
    private final HashMap<String, String> data = new HashMap();
    private final MultiMap<String, String> tree = new MultiMap();
    public static final String NULL_VALUE = "#NULL!";
    private boolean hasLoaded;

    private XMLInterface(LoadFormat f, Object raw, String disp, boolean crashIfNull) {
        this.format = f;
        this.loadData = new LoadPoint();
        this.loadData.paths.add(raw);
        this.requireFile = crashIfNull;
        this.pathString = disp;
    }

    public XMLInterface(File path, boolean crashIfNull) {
        this(LoadFormat.FILE, path, path.getAbsolutePath(), crashIfNull);
    }

    public XMLInterface(Class root, String path) {
        this(root, path, false);
    }

    public XMLInterface(Class root, String path, boolean crashIfNull) {
        this(LoadFormat.JARPATH, path, path + " relative to " + root.getName(), crashIfNull);
        this.referenceClass = root;
    }

    public XMLInterface(DataProvider p, boolean crashIfNull) {
        this(LoadFormat.CUSTOM, p, "Custom loader " + p, crashIfNull);
    }

    public void setFallback(String s) {
        this.loadData.addEntry(s);
    }

    public void setEncrypted() {
        this.isEncrypted = true;
    }

    public XMLInterface init() {
        try {
            InputStream in = this.loadData.getInputStream();
            if (this.isEncrypted) {
                in = ReikaFileReader.decryptInputStream(in);
            }
            this.doc = ReikaXMLBase.getXMLDocument(in);
            this.readFileToMap();
            this.hasLoaded = true;
        }
        catch (FileNotFoundException e) {
            if (this.requireFile) {
                throw new RuntimeException("XML not found at " + this.pathString, e);
            }
            e.printStackTrace();
        }
        catch (SAXException e) {
            if (this.requireFile) {
                throw new RuntimeException("Could not parse XML at " + this.pathString, e);
            }
            e.printStackTrace();
        }
        catch (IOException e) {
            if (this.requireFile) {
                throw new RuntimeException("Could not load XML at " + this.pathString, e);
            }
            e.printStackTrace();
        }
        return this;
    }

    public void reread() {
        if (this.format == LoadFormat.CUSTOM && !((DataProvider)this.loadData.paths.get(0)).canBeReloaded()) {
            throw new MisuseException("This data provider cannot be reloaded!");
        }
        this.hasLoaded = false;
        this.data.clear();
        this.tree.clear();
        this.init();
    }

    private void readFileToMap() {
        this.recursiveRead("$TOP$", this.doc);
    }

    private void recursiveRead(String parent, Node n) {
        if (n == null) {
            return;
        }
        NodeList li = n.getChildNodes();
        int len = li.getLength();
        for (int i = 0; i < len; ++i) {
            Node ch = li.item(i);
            String key = ReikaXMLBase.getNodeNameTree(ch);
            this.tree.addValue(parent, key);
            if (ch.getNodeType() == 1) {
                this.recursiveRead(key, ch);
                continue;
            }
            if (ch.getNodeType() != 3) continue;
            String val = ch.getNodeValue();
            if (val != null) {
                if (val.equals("\n")) {
                    val = null;
                } else {
                    if (val.startsWith("\n")) {
                        val = val.substring(1);
                    }
                    if (val.endsWith("\n")) {
                        val = val.substring(0, val.length() - 1);
                    }
                }
                if (val != null && val.equals("\n")) {
                    val = null;
                }
            }
            if (val == null) continue;
            if (this.data.containsKey(key)) {
                // empty if block
            }
            this.data.put(key, this.cleanString(val));
        }
    }

    private String cleanString(String val) {
        val = val.replace("\t", "");
        while (!val.isEmpty() && val.endsWith("\\n")) {
            val = val.substring(0, val.length() - 2);
        }
        while (!val.isEmpty() && val.charAt(0) == ' ') {
            val = val.substring(1);
        }
        while (!val.isEmpty() && val.charAt(val.length() - 1) == ' ') {
            val = val.substring(0, val.length() - 1);
        }
        val = val.replaceAll("\\[i\\]", EnumChatFormatting.ITALIC.toString());
        val = val.replaceAll("\\[b\\]", EnumChatFormatting.BOLD.toString());
        val = val.replaceAll("\\[u\\]", EnumChatFormatting.UNDERLINE.toString());
        val = val.replaceAll("\\[s\\]", EnumChatFormatting.STRIKETHROUGH.toString());
        val = val.replaceAll("\\[/i\\]", EnumChatFormatting.RESET.toString());
        val = val.replaceAll("\\[/b\\]", EnumChatFormatting.RESET.toString());
        val = val.replaceAll("\\[/u\\]", EnumChatFormatting.RESET.toString());
        val = val.replaceAll("\\[/s\\]", EnumChatFormatting.RESET.toString());
        return val;
    }

    public String getValueAtNode(String name) {
        if (!this.hasLoaded) {
            throw new MisuseException("You cannot query an XML data set before reading it from disk!");
        }
        String dat = this.data.get(name);
        if (dat == null) {
            dat = NULL_VALUE;
        }
        return dat;
    }

    public boolean nodeExists(String name) {
        if (!this.hasLoaded) {
            throw new MisuseException("You cannot query an XML data set before reading it from disk!");
        }
        return this.data.containsKey(name);
    }

    public Collection<String> getNodesWithin(String name) {
        if (!this.hasLoaded) {
            throw new MisuseException("You cannot query an XML data set before reading it from disk!");
        }
        return name == null ? this.getTopNodes() : this.tree.get(name);
    }

    public Collection<String> getTopNodes() {
        if (!this.hasLoaded) {
            throw new MisuseException("You cannot query an XML data set before reading it from disk!");
        }
        return this.tree.get("$TOP$");
    }

    public String toString() {
        if (!this.hasLoaded) {
            return "NOT LOADED";
        }
        return this.data.toString();
    }

    private static enum LoadFormat {
        JARPATH,
        FILE,
        CUSTOM;


        private InputStream getInputStream(Object ... data) throws IOException {
            switch (this) {
                case FILE: {
                    return new FileInputStream((File)data[0]);
                }
                case JARPATH: {
                    InputStream ret = ((Class)data[0]).getResourceAsStream((String)data[1]);
                    if (ret == null) {
                        String s = ((Class)data[0]).getCanonicalName();
                        throw new FileNotFoundException(s + " >> " + (String)data[1]);
                    }
                    return ret;
                }
                case CUSTOM: {
                    return ((DataProvider)data[0]).getDataStream();
                }
            }
            return null;
        }
    }

    private class LoadPoint {
        private final ArrayList<Object> paths = new ArrayList();

        private LoadPoint() {
        }

        public void addEntry(String s) {
            Object add = s;
            switch (XMLInterface.this.format) {
                case FILE: {
                    add = new File(s);
                    break;
                }
                case JARPATH: {
                    break;
                }
            }
            this.paths.add(add);
        }

        private InputStream getInputStream() throws IOException {
            IOException ex = null;
            for (int i = 0; i < this.paths.size(); ++i) {
                try {
                    switch (XMLInterface.this.format) {
                        case FILE: {
                            return XMLInterface.this.format.getInputStream(new Object[]{this.paths.get(i)});
                        }
                        case JARPATH: {
                            return XMLInterface.this.format.getInputStream(new Object[]{XMLInterface.this.referenceClass, this.paths.get(i)});
                        }
                        case CUSTOM: {
                            return XMLInterface.this.format.getInputStream(new Object[]{this.paths.get(i)});
                        }
                    }
                    continue;
                }
                catch (IOException e) {
                    if (i == 0) {
                        ex = e;
                        continue;
                    }
                    if (i != this.paths.size() - 1) continue;
                }
            }
            throw ex;
        }
    }
}

