/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import net.minecraft.util.MathHelper;

public class ScrollingButtonList {
    public final int maxRows;
    public final int maxCols;
    private int currentScroll;
    private int maxScroll;
    private int allButtons = 0;

    public ScrollingButtonList(int r, int c) {
        this.maxCols = c;
        this.maxRows = r;
    }

    public void addButton() {
        ++this.allButtons;
        int rowMax = MathHelper.func_76123_f((float)((float)this.getTotalSize() / (float)this.maxCols));
        this.maxScroll = rowMax - this.maxRows;
    }

    public boolean scrollUp() {
        if (this.currentScroll > 0) {
            --this.currentScroll;
            return true;
        }
        return false;
    }

    public boolean scrollDown() {
        if (this.currentScroll < this.maxScroll) {
            ++this.currentScroll;
            return true;
        }
        return false;
    }

    public int getOffsetPosition(int pos) {
        int idx = pos + this.getBaseOffset();
        return idx;
    }

    public int getBaseOffset() {
        return this.currentScroll * this.maxCols;
    }

    public int getHighestVisible() {
        return this.getBaseOffset() + this.getWindowSize() - 1;
    }

    public int getWindowSize() {
        return this.maxRows * this.maxCols;
    }

    public int getTotalSize() {
        return this.allButtons;
    }

    public int getScroll() {
        return this.currentScroll;
    }

    public void reset() {
        this.allButtons = 0;
        this.currentScroll = 0;
    }
}

