/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Instantiable.Data.CircularDivisionRenderer;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class Proportionality<F>
extends CircularDivisionRenderer<F> {
    private final Map<F, Double> data;
    private double totalValue = 0.0;

    public Proportionality() {
        this(null);
    }

    public Proportionality(MultiMap.MapDeterminator<F, ?> md) {
        this.data = md != null ? md.getMapType() : new HashMap<F, Double>();
    }

    public void addValue(F o, double amt) {
        Double get = this.data.get(o);
        double val = get != null ? get : 0.0;
        this.data.put(o, val + amt);
        this.totalValue += amt;
        if (o instanceof CircularDivisionRenderer.ColorCallback) {
            this.addColorRenderer(o, (CircularDivisionRenderer.ColorCallback)o);
        }
        this.resetColors();
    }

    public void removeValue(F o, double amt) {
        Double get = this.data.get(o);
        double val = get != null ? get : 0.0;
        double res = val - amt;
        this.totalValue -= Math.min(amt, val);
        if (res > 0.0) {
            this.data.put(o, res);
        } else {
            this.data.remove(o);
        }
        this.resetColors();
    }

    public double getValue(F o) {
        Double get = this.data.get(o);
        return get != null ? get : 0.0;
    }

    public double getFraction(F o) {
        return this.getValue(o) / this.totalValue;
    }

    @Override
    public Collection<F> getElements() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public boolean hasMajority(F o) {
        return this.getFraction(o) >= 0.5;
    }

    public F getLargestCategory() {
        double max = -1.0;
        F big = null;
        for (F o : this.data.keySet()) {
            double has = this.getValue(o);
            if (!(has > max)) continue;
            has = max;
            big = o;
        }
        return big;
    }

    @Override
    public void clear() {
        this.data.clear();
        this.resetColors();
    }

    @Override
    public F getClickedSection(int x, int y) {
        double d = ReikaMathLibrary.py3d((double)x - this.centerX, (double)y - this.centerY, 0.0);
        if (d > this.renderRadius) {
            return null;
        }
        double relAng = (Math.toDegrees(Math.atan2((double)y - this.centerY, (double)x - this.centerX)) + 360.0) % 360.0;
        double ang = this.renderOrigin;
        for (F o : this.data.keySet()) {
            double angw = 360.0 * this.getFraction(o);
            if (ang <= relAng && ang + angw >= relAng) {
                return o;
            }
            ang += angw;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Map<F, Integer> colorMap) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        double ang = this.renderOrigin;
        Tessellator v5 = Tessellator.field_78398_a;
        boolean i = false;
        for (F o : this.data.keySet()) {
            double angw = 360.0 * this.getFraction(o);
            v5.func_78371_b(this.innerRadius == 0.0 ? 6 : 5);
            int c = this.getColorForElement(o, colorMap);
            v5.func_78378_d(c);
            this.renderSection(v5, ang, ang + angw);
            v5.func_78381_a();
            ang += angw;
        }
        GL11.glPopAttrib();
    }
}

