/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import java.util.HashMap;

public class BranchingTree<B, L> {
    private final HashMap<B, TreeNode<B, L>> data = new HashMap();

    public void addPath(L leaf, B ... branches) {
        TreeNode<B, L> par = null;
        for (int i = 0; i < branches.length; ++i) {
            TreeNode<B, L> node;
            B branch = branches[i];
            par = node = this.getOrCreateNode(par, branch);
        }
        ((TreeNode)par).setLeaf(leaf);
    }

    public TreeNavigator getNavigator() {
        return new TreeNavigator(this);
    }

    private TreeNode<B, L> getOrCreateNode(TreeNode par, B branch) {
        HashMap map = par == null ? this.data : par.children;
        TreeNode n = (TreeNode)map.get(branch);
        if (n == null) {
            n = new TreeNode(par, branch);
            map.put(branch, n);
        }
        return n;
    }

    private TreeNode<B, L> getNode(TreeNode par, B branch) {
        HashMap map = par == null ? this.data : par.children;
        return (TreeNode)map.get(branch);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (B b : this.data.keySet()) {
            sb.append(b);
            sb.append("=[");
            TreeNode<B, L> n = this.data.get(b);
            sb.append(this.getString(1, n));
            sb.append("];\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String getString(int d, TreeNode<B, L> n) {
        StringBuilder sb = new StringBuilder();
        for (Object b : ((TreeNode)n).children.keySet()) {
            for (int i = 0; i < d; ++i) {
                sb.append("\t");
            }
            sb.append(b);
            sb.append("=[");
            TreeNode n2 = (TreeNode)((TreeNode)n).children.get(b);
            sb.append(this.getString(d + 1, n2));
            sb.append("];");
        }
        sb.append("\n");
        if (((TreeNode)n).leaf != null) {
            sb.append("(" + ((TreeNode)n).leaf + ")");
        }
        return sb.toString();
    }

    public class TreeNavigator {
        protected final BranchingTree<B, L> tree;
        private TreeNode<B, L> currentNode;

        private TreeNavigator(BranchingTree<B, L> t) {
            this.tree = t;
        }

        public boolean stepUp() {
            TreeNode last = this.currentNode;
            if (this.currentNode != null) {
                this.currentNode = this.currentNode.parent;
            }
            return last != this.currentNode;
        }

        public boolean stepDown(B branch) {
            this.currentNode = BranchingTree.this.getNode(this.currentNode, branch);
            return this.currentNode != null;
        }

        public L getLeaf() {
            return this.currentNode != null ? this.currentNode.leaf : null;
        }
    }

    private static class TreeNode<B, L> {
        private final TreeNode<B, L> parent;
        private final B parentBranch;
        private final HashMap<B, TreeNode<B, L>> children = new HashMap();
        private L leaf;

        private TreeNode(TreeNode<B, L> par, B parB) {
            this.parent = par;
            this.parentBranch = parB;
        }

        private void setLeaf(L leaf) {
            if (this.leaf != null) {
                throw new IllegalArgumentException("Leaves cannot be modified!");
            }
            this.leaf = leaf;
        }

        public String toString() {
            return "[" + this.leaf + "] & " + this.children.toString();
        }
    }
}

