/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Immutable;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import net.minecraftforge.common.util.ForgeDirection;

public class ProportionedBlockBox {
    public final BlockBox volume;
    public final int totalFaceArea;
    public final int totalEdgeLength;
    private final WeightedRandom<ForgeDirection> faceAreas = new WeightedRandom();
    private final WeightedRandom<CubeEdge> edgeLengths = new WeightedRandom();

    public ProportionedBlockBox(BlockBox box) {
        this.volume = box;
        this.totalFaceArea = this.calculateFaces();
        this.totalEdgeLength = this.calculateEdges();
    }

    private int calculateFaces() {
        int area = this.volume.getSizeX() * this.volume.getSizeZ();
        this.faceAreas.addEntry(ForgeDirection.UP, area);
        this.faceAreas.addEntry(ForgeDirection.DOWN, area);
        area = this.volume.getSizeZ() * this.volume.getSizeY();
        this.faceAreas.addEntry(ForgeDirection.EAST, area);
        this.faceAreas.addEntry(ForgeDirection.WEST, area);
        area = this.volume.getSizeX() * this.volume.getSizeY();
        this.faceAreas.addEntry(ForgeDirection.SOUTH, area);
        this.faceAreas.addEntry(ForgeDirection.NORTH, area);
        return (int)this.faceAreas.getTotalWeight();
    }

    private int calculateEdges() {
        int len = this.volume.getSizeY();
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.minY, this.volume.minZ), ForgeDirection.UP, len, false, false, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.maxX - 1, this.volume.minY, this.volume.minZ), ForgeDirection.UP, len, true, false, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.maxX - 1, this.volume.minY, this.volume.maxZ - 1), ForgeDirection.UP, len, true, false, true), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.minY, this.volume.maxZ - 1), ForgeDirection.UP, len, false, false, true), len);
        len = this.volume.getSizeX();
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.minY, this.volume.minZ), ForgeDirection.EAST, len, false, false, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.maxY - 1, this.volume.minZ), ForgeDirection.EAST, len, false, true, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.minY, this.volume.maxZ - 1), ForgeDirection.EAST, len, false, false, true), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.maxY - 1, this.volume.maxZ - 1), ForgeDirection.EAST, len, false, true, true), len);
        len = this.volume.getSizeZ();
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.minY, this.volume.minZ), ForgeDirection.SOUTH, len, false, false, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.minX, this.volume.maxY - 1, this.volume.minZ), ForgeDirection.SOUTH, len, false, true, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.maxX - 1, this.volume.minY, this.volume.minZ), ForgeDirection.SOUTH, len, true, false, false), len);
        this.edgeLengths.addEntry(new CubeEdge(new Coordinate(this.volume.maxX - 1, this.volume.maxY - 1, this.volume.minZ), ForgeDirection.SOUTH, len, true, true, false), len);
        return (int)this.edgeLengths.getTotalWeight();
    }

    public ForgeDirection getRandomFace() {
        return this.faceAreas.getRandomEntry();
    }

    public CubeEdge getRandomEdge() {
        return this.edgeLengths.getRandomEntry();
    }

    public static class CubeEdge {
        public final Coordinate root;
        public final ForgeDirection axis;
        public final int length;
        public final boolean isPositiveX;
        public final boolean isPositiveY;
        public final boolean isPositiveZ;

        private CubeEdge(Coordinate c, ForgeDirection dir, int l, boolean px, boolean py, boolean pz) {
            this.root = c;
            this.axis = dir;
            this.length = l;
            this.isPositiveX = px;
            this.isPositiveY = py;
            this.isPositiveZ = pz;
        }
    }
}

