/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class SelectiveKillCommand
extends DragonCommandBase {
    @Override
    public String getCommandString() {
        return "selectivekill";
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        World world = null;
        if (ics instanceof CommandBlockLogic) {
            world = ((CommandBlockLogic)ics).func_130014_f_();
        } else {
            EntityPlayerMP ep = SelectiveKillCommand.func_71521_c((ICommandSender)ics);
            world = ep.field_70170_p;
        }
        if (args.length == 2) {
            String c = args[0];
            int percentage = ReikaJavaLibrary.safeIntParse(args[1]);
            if (percentage == 0) {
                String sg = EnumChatFormatting.RED + "Invalid percentage.";
                SelectiveKillCommand.sendChatToSender(ics, sg);
                return;
            }
            int amt = this.killEntity(world, c, percentage);
            String sg = EnumChatFormatting.GREEN + "Killed " + amt + " of " + c + ".";
            SelectiveKillCommand.sendChatToSender(ics, sg);
        } else {
            String sg = EnumChatFormatting.RED + "You must specify an entity class and a kill percentage!";
            String sg2 = "'EntityAnimal', 'EntityMob', 'EntityCreature', and 'EntityLiving' are accepted parent classes.";
            SelectiveKillCommand.sendChatToSender(ics, sg);
            SelectiveKillCommand.sendChatToSender(ics, sg2);
        }
    }

    private int killEntity(World world, String name, int percentage) {
        List li = world.field_72996_f;
        boolean isMobs = name.equals("EntityMob");
        boolean isAnimals = name.equals("EntityAnimal");
        boolean isCreatures = name.equals("EntityCreature");
        boolean allLiving = name.equals("EntityLiving");
        boolean all = name.equals("Entity");
        int killed = 0;
        for (int i = 0; i < li.size(); ++i) {
            boolean protect;
            Entity e = (Entity)li.get(i);
            if (all) {
                if (e instanceof EntityPlayer || !ReikaRandomHelper.doWithChance(percentage)) continue;
                e.func_70106_y();
                ++killed;
                continue;
            }
            if (allLiving) {
                if (!(e instanceof EntityLiving)) continue;
                protect = false;
                if (e instanceof EntityTameable) {
                    protect = ((EntityTameable)e).func_70909_n();
                }
                if (e instanceof TameHostile) {
                    protect = true;
                }
                if (protect || !ReikaRandomHelper.doWithChance(percentage)) continue;
                e.func_70106_y();
                ++killed;
                continue;
            }
            if (isMobs) {
                if (!(e instanceof EntityMob) || e instanceof TameHostile || !ReikaRandomHelper.doWithChance(percentage)) continue;
                e.func_70106_y();
                ++killed;
                continue;
            }
            if (isAnimals) {
                if (!(e instanceof EntityAnimal)) continue;
                protect = false;
                if (e instanceof EntityTameable) {
                    protect = ((EntityTameable)e).func_70909_n();
                }
                if (protect || !ReikaRandomHelper.doWithChance(percentage)) continue;
                e.func_70106_y();
                ++killed;
                continue;
            }
            if (isCreatures) {
                if (!(e instanceof EntityCreature)) continue;
                protect = false;
                if (e instanceof EntityTameable) {
                    protect = ((EntityTameable)e).func_70909_n();
                }
                if (protect || !ReikaRandomHelper.doWithChance(percentage)) continue;
                e.func_70106_y();
                ++killed;
                continue;
            }
            if (!e.getClass().getSimpleName().equals(name) || !ReikaRandomHelper.doWithChance(percentage)) continue;
            e.func_70106_y();
            ++killed;
        }
        return killed;
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }
}

