/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.ChromatiCraft.API.TreeGetter;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;

public class BlockReplaceCommand
extends DragonCommandBase {
    @Override
    public String getCommandString() {
        return "blockreplace";
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        EntityPlayerMP ep = BlockReplaceCommand.func_71521_c((ICommandSender)ics);
        if (args.length == 3) {
            ArrayList<ReplaceCheck> li = new ArrayList<ReplaceCheck>();
            String[] parts = args[0].split(",");
            for (int i = 0; i < parts.length; ++i) {
                ReplaceCheck rc = this.getCheck(parts[i]);
                if (rc == null) continue;
                li.add(rc);
            }
            int range = ReikaJavaLibrary.safeIntParse(args[2]);
            if (range <= 0) {
                String sg = EnumChatFormatting.RED + "Invalid range '" + range + "'.";
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
                return;
            }
            BlockKey to = this.getBlockTo(args[1]);
            int px = MathHelper.func_76128_c((double)ep.field_70165_t);
            int py = MathHelper.func_76128_c((double)ep.field_70163_u);
            int pz = MathHelper.func_76128_c((double)ep.field_70161_v);
            long start = System.currentTimeMillis();
            int count = 0;
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    block3: for (int k = -range; k <= range; ++k) {
                        int x = px + i;
                        int y = py + j;
                        int z = pz + k;
                        if (y < 0 || y > 256) continue;
                        Block b = ep.field_70170_p.func_147439_a(x, y, z);
                        int meta = ep.field_70170_p.func_72805_g(x, y, z);
                        for (ReplaceCheck rc : li) {
                            if (!rc.replace(b, meta)) continue;
                            ep.field_70170_p.func_147465_d(x, y, z, to.blockID, to.metadata, 3);
                            ++count;
                            continue block3;
                        }
                    }
                }
            }
            if (count > 0) {
                String s2 = to.blockID.func_149732_F() + " (Metadata " + to.metadata + ")";
                long dur = System.currentTimeMillis() - start;
                String sg = EnumChatFormatting.GREEN + "Replaced " + count + " blocks with " + s2 + " in range " + range + ". Took " + dur + " ms.";
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
            }
        } else {
            String sg = EnumChatFormatting.RED + "You must specify a source block, a target block, and a range!";
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
        }
    }

    private BlockKey getBlockTo(String s) {
        String[] parts = s.split(":");
        Block b = Block.func_149729_e((int)Integer.parseInt(parts[0]));
        int meta = 0;
        if (parts.length == 2) {
            meta = Integer.parseInt(parts[1]);
        }
        return new BlockKey(b, meta);
    }

    private ReplaceCheck getCheck(String s) {
        if (s.equals("all_ores")) {
            return new OreCheck();
        }
        if (s.equals("all_trees")) {
            return new TreeCheck();
        }
        if (s.equals("all_fluids")) {
            return new FluidCheck();
        }
        if (s.startsWith("class_")) {
            return new ClassCheck(s.substring(6).toLowerCase(Locale.ENGLISH));
        }
        if (s.equals("any") || s.equals("all") || s.equals("*")) {
            return new AnyCheck();
        }
        if (s.startsWith("!") || s.startsWith("~")) {
            try {
                int id = Integer.parseInt(s.substring(1));
                return new AnyButCheck(id);
            }
            catch (NumberFormatException id) {}
        } else {
            try {
                int id = Integer.parseInt(s);
                return new IDCheck(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    private static abstract class ReplaceCheck {
        private ReplaceCheck() {
        }

        protected abstract boolean replace(Block var1, int var2);
    }

    private static class AnyButCheck
    extends ReplaceCheck {
        private final int blockID;

        private AnyButCheck(int id) {
            this.blockID = id;
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return Block.func_149682_b((Block)b) != this.blockID;
        }
    }

    private static class AnyCheck
    extends ReplaceCheck {
        private AnyCheck() {
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return b != Blocks.field_150350_a;
        }
    }

    private static class IDCheck
    extends ReplaceCheck {
        private final int blockID;

        private IDCheck(int id) {
            this.blockID = id;
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return Block.func_149682_b((Block)b) == this.blockID;
        }
    }

    private static class ClassCheck
    extends ReplaceCheck {
        private final String blockClass;

        private ClassCheck(String c) {
            this.blockClass = c;
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return b.getClass().getSimpleName().toLowerCase(Locale.ENGLISH).equals(this.blockClass);
        }
    }

    private static class FluidCheck
    extends ReplaceCheck {
        private FluidCheck() {
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return ReikaBlockHelper.isLiquid(b);
        }
    }

    private static class OreCheck
    extends ReplaceCheck {
        private OreCheck() {
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return ReikaOreHelper.isVanillaOre(b) || ModOreList.isModOre(b, meta);
        }
    }

    private static class TreeCheck
    extends ReplaceCheck {
        private TreeCheck() {
        }

        @Override
        protected boolean replace(Block b, int meta) {
            return ReikaTreeHelper.getTree(b, meta) != null || ReikaTreeHelper.getTreeFromLeaf(b, meta) != null || ModWoodList.isModWood(b, meta) || ModWoodList.isModLeaf(b, meta) || TreeGetter.isDyeLeaf(new ItemStack(b, 1, meta)) || TreeGetter.isRainbowLeaf(new ItemStack(b, 1, meta));
        }
    }
}

