/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Instantiable.Event.EntityAboutToRayTraceEvent;
import Reika.DragonAPI.Instantiable.Event.ItemUpdateEvent;
import Reika.DragonAPI.Instantiable.Event.SetBlockEvent;
import Reika.DragonAPI.Instantiable.Event.TileUpdateEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.IEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class EventProfiler {
    private static HashMap<String, Class<? extends Event>> fullNameShortcuts = new HashMap();
    private static Class currentProfile;
    private static HashMap<IEventListener, EventProfile> profileData;
    private static int totalCount;

    public static void addShortcut(Class<? extends Event> eventType) {
        fullNameShortcuts.put(eventType.getSimpleName(), eventType);
    }

    public static void startProfiling(Class<? extends Event> c) {
        if (currentProfile != null) {
            DragonAPICore.logError("You cannot start profiling while profiling is running!");
            Thread.dumpStack();
            return;
        }
        currentProfile = c;
    }

    public static ProfileStartStatus startProfiling(String eventType) {
        if (currentProfile != null) {
            return ProfileStartStatus.ALREADYRUNNING;
        }
        profileData.clear();
        totalCount = 0;
        try {
            if (fullNameShortcuts.containsKey(eventType)) {
                EventProfiler.startProfiling(fullNameShortcuts.get(eventType));
            } else {
                EventProfiler.startProfiling(Class.forName(eventType));
            }
            return ProfileStartStatus.SUCCESS;
        }
        catch (ClassNotFoundException e) {
            return ProfileStartStatus.NOSUCHCLASS;
        }
        catch (ClassCastException e) {
            return ProfileStartStatus.NOTANEVENT;
        }
    }

    public static void finishProfiling() {
        currentProfile = null;
    }

    public static ArrayList<EventProfile> getProfilingData() {
        ArrayList<EventProfile> li = new ArrayList<EventProfile>(profileData.values());
        Iterator<EventProfile> it = li.iterator();
        while (it.hasNext()) {
            EventProfile e = it.next();
            if (e.identifier != null) continue;
            it.remove();
        }
        Collections.sort(li);
        return li;
    }

    public static long getTotalProfilingTime() {
        long total = 0L;
        for (EventProfile g : profileData.values()) {
            if (g.identifier == null) continue;
            total += g.getTotalTime();
        }
        return total;
    }

    public static String getProfiledEventType() {
        return currentProfile.getName();
    }

    public static int getEventFireCount() {
        return totalCount / profileData.size();
    }

    private static EventProfile getOrCreateProfile(IEventListener e) {
        EventProfile a = profileData.get(e);
        if (a == null) {
            a = new EventProfile(e);
            profileData.put(e, a);
        }
        return a;
    }

    public static void firePre(Event e, IEventListener listener) {
        if (e.getClass() == currentProfile) {
            EventProfile a = EventProfiler.getOrCreateProfile(listener);
            if (a.identifier != null) {
                a.startTiming();
                ++totalCount;
            }
        }
    }

    public static void firePost(Event e, IEventListener listener) {
        if (e.getClass() == currentProfile) {
            EventProfile a = EventProfiler.getOrCreateProfile(listener);
            if (a.identifier != null) {
                a.stopTiming();
            }
        }
    }

    static {
        EventProfiler.addShortcut(ChunkProviderEvent.ReplaceBiomeBlocks.class);
        EventProfiler.addShortcut(PopulateChunkEvent.Populate.class);
        EventProfiler.addShortcut(EntityJoinWorldEvent.class);
        EventProfiler.addShortcut(LivingHurtEvent.class);
        EventProfiler.addShortcut(EntityItemPickupEvent.class);
        EventProfiler.addShortcut(ItemTooltipEvent.class);
        EventProfiler.addShortcut(LivingEvent.LivingUpdateEvent.class);
        EventProfiler.addShortcut(RenderGameOverlayEvent.class);
        EventProfiler.addShortcut(RenderWorldEvent.class);
        EventProfiler.addShortcut(SetBlockEvent.class);
        EventProfiler.addShortcut(BlockTickEvent.class);
        EventProfiler.addShortcut(EntityAboutToRayTraceEvent.class);
        EventProfiler.addShortcut(TileUpdateEvent.class);
        EventProfiler.addShortcut(ItemUpdateEvent.class);
        profileData = new HashMap();
    }

    public static class EventProfile
    implements Comparable<EventProfile> {
        public final String identifier;
        public final Class identifyingClass;
        private long totalTime;
        private int fireCount;
        private long lastStart;

        private EventProfile(IEventListener e) {
            this.identifyingClass = e.getClass();
            String s = e.toString();
            String arg = currentProfile.getName().replace(".", "/");
            s = s.replace("(L" + arg + ";)V", "()");
            s = s.startsWith("ASM: ") ? s.substring("ASM: ".length()) : null;
            this.identifier = s;
        }

        private void startTiming() {
            ++this.fireCount;
            this.lastStart = System.nanoTime();
        }

        private void stopTiming() {
            this.totalTime += System.nanoTime() - this.lastStart;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public long getAverageTime() {
            return this.totalTime / (long)this.fireCount;
        }

        @Override
        public int compareTo(EventProfile o) {
            return -Long.compare(this.totalTime, o.totalTime);
        }
    }

    public static enum ProfileStartStatus {
        SUCCESS,
        ALREADYRUNNING,
        NOSUCHCLASS,
        NOTANEVENT;

    }
}

