/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.EnvironmentSanityException;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class EnvironmentSanityChecker {
    public static final EnvironmentSanityChecker instance = new EnvironmentSanityChecker();

    private EnvironmentSanityChecker() {
    }

    public void check() {
        this.checkBlocks();
        this.checkItems();
        this.checkBiomes();
        this.checkEnchants();
        this.checkPotions();
        this.checkDungeonLoot();
        this.checkOreDict();
    }

    private void checkBlocks() {
        for (String s : Block.field_149771_c.func_148742_b()) {
            Block b = (Block)Block.field_149771_c.func_82594_a(s);
            if (s == null) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.NULLREG, b);
            }
            if (b == null) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.NULLENTRY, s);
            }
            this.verifyBlock(b);
        }
    }

    private void checkItems() {
        for (String s : Item.field_150901_e.func_148742_b()) {
            Item b = (Item)Item.field_150901_e.func_82594_a(s);
            if (s == null) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.NULLREG, b);
            }
            if (b == null) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.NULLENTRY, s);
            }
            this.verifyItem(b);
        }
    }

    private void checkBiomes() {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (b == null) continue;
            if (b.field_76756_M != i) {
                if (i != BiomeGenBase.field_150581_V.field_76756_M + 128 + 1) continue;
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.IDMISMATCH, b, i, b.field_76756_M);
            }
            this.verifyBiome(b);
        }
    }

    private void checkEnchants() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            Enchantment e = Enchantment.field_77331_b[i];
            if (e == null) continue;
            if (e.field_77352_x != i) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.IDMISMATCH, e, i, e.field_77352_x);
            }
            this.verifyEnchant(e);
        }
    }

    private void checkPotions() {
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            Potion p = Potion.field_76425_a[i];
            if (p == null) continue;
            if (p.field_76415_H != i) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.IDMISMATCH, p, i, p.field_76415_H);
            }
            this.verifyPotion(p);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDungeonLoot() {
        try {
            Field f = ChestGenHooks.class.getDeclaredField("chestInfo");
            f.setAccessible(true);
            Field f2 = ChestGenHooks.class.getDeclaredField("contents");
            f2.setAccessible(true);
            Map map = (Map)f.get(null);
            for (String s : map.keySet()) {
                ChestGenHooks c = (ChestGenHooks)map.get(s);
                ArrayList li = (ArrayList)f2.get(c);
                Iterator it = li.iterator();
                while (it.hasNext()) {
                    WeightedRandomChestContent w = (WeightedRandomChestContent)it.next();
                    ItemStack is = w.field_76297_b;
                    try {
                        if (is == null) {
                            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.LOOT, is, s, "Null Stack");
                        }
                        if (is.func_77973_b() == null) {
                            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.LOOT, is, s, "Null-Item ItemStack");
                        }
                        if (ReikaItemHelper.verifyItemStack(is, true)) continue;
                        throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.LOOT, is, s, "Errors on handling");
                    }
                    catch (EnvironmentSanityException e) {
                        if (!DragonOptions.FIXSANITY.getState()) throw e;
                        DragonAPICore.logError("Found invalid item " + EnvironmentSanityChecker.getSafeItemString(is) + " registered to dungeon loot tag '" + s + "'");
                        it.remove();
                    }
                }
                continue;
                return;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkOreDict() {
        String[] tags = OreDictionary.getOreNames();
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            ArrayList li = new ArrayList(OreDictionary.getOres((String)tag));
            for (ItemStack is : li) {
                try {
                    this.verifyOreDictItem(tag, is);
                }
                catch (EnvironmentSanityException e) {
                    if (DragonOptions.FIXSANITY.getState()) {
                        try {
                            DragonAPICore.logError("Found invalid item " + EnvironmentSanityChecker.getSafeItemString(is) + " registered to OreDict " + tag + ": " + e);
                            e.printStackTrace();
                            ReikaItemHelper.removeOreDictEntry(tag, is);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.initCause(e);
                            throw new RuntimeException(ex);
                        }
                    }
                    throw e;
                }
            }
        }
    }

    private void verifyOreDictItem(String tag, ItemStack is) {
        try {
            is.func_77977_a();
        }
        catch (Exception e) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.OREDICT, is, tag, e, "Name");
        }
        try {
            is.func_82833_r();
        }
        catch (Exception e) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.OREDICT, is, tag, e, "Display Name");
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.doClientOreDictVerification(tag, is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doClientOreDictVerification(String tag, ItemStack is2) {
        is2.func_77973_b().func_94581_a((IIconRegister)ReikaTextureHelper.dummyTextureMap);
        Block b = Block.func_149634_a((Item)is2.func_77973_b());
        if (b != null) {
            b.func_149651_a((IIconRegister)ReikaTextureHelper.dummyTextureMap);
        }
        ArrayList li = new ArrayList();
        is2.func_77973_b().func_150895_a(is2.func_77973_b(), is2.func_77973_b().func_77640_w(), li);
        for (ItemStack is : li) {
            try {
                is.func_77954_c();
            }
            catch (Exception e) {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.OREDICT, is, tag, e, "Icon");
            }
            boolean draw = Tessellator.field_78398_a.field_78415_z;
            try {
                ReikaGuiAPI.instance.drawItemStack(ReikaGuiAPI.itemRenderer, is, 0, 0);
            }
            catch (Exception e) {
                Tessellator.field_78398_a.field_78415_z = draw;
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.OREDICT, is, tag, e, "Render");
            }
        }
    }

    public void verifyBlock(Block b) throws EnvironmentSanityException {
        if (b.func_149688_o() == null) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, b.func_149688_o(), "Material");
        }
        if (b.field_149762_H == null) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, b.field_149762_H, "Step Sound");
        }
        if (b instanceof IFluidBlock && ((IFluidBlock)b).getFluid() == null) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, null, "Null-fluid fluid block");
        }
        try {
            b.func_149732_F();
        }
        catch (Exception e) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.UNPARSEABLE, b, e, "Localization");
        }
    }

    public void verifyItem(Item i) throws EnvironmentSanityException {
        try {
            i.func_77658_a();
        }
        catch (Exception e) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.UNPARSEABLE, i, e, "Name");
        }
        try {
            i.func_77612_l();
        }
        catch (Exception e) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.UNPARSEABLE, i, e, "Max Damage");
        }
        try {
            i.getItemStackLimit(new ItemStack(i));
        }
        catch (Exception e) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.UNPARSEABLE, i, e, "Stacksize Limit");
        }
    }

    public void verifyBiome(BiomeGenBase b) throws EnvironmentSanityException {
        if (b.field_76791_y == null) {
            if (DragonOptions.FIXSANITY.getState()) {
                b.field_76791_y = "NULL";
            } else {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, b.field_76791_y, "Name");
            }
        }
        if (b.field_76752_A == null) {
            if (DragonOptions.FIXSANITY.getState()) {
                b.field_76752_A = Blocks.field_150349_c;
            } else {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, b.field_76752_A, "Top Block");
            }
        }
        if (b.field_76753_B == null) {
            if (DragonOptions.FIXSANITY.getState()) {
                b.field_76753_B = Blocks.field_150346_d;
            } else {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, b.field_76753_B, "Filler Block");
            }
        }
        if (b.field_76760_I == null) {
            if (DragonOptions.FIXSANITY.getState()) {
                b.field_76760_I = new BiomeDecorator();
            } else {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, b, b.field_76760_I, "Decorator");
            }
        }
    }

    public void verifyEnchant(Enchantment e) throws EnvironmentSanityException {
        if (e.field_77351_y == null) {
            if (DragonOptions.FIXSANITY.getState()) {
                e.field_77351_y = EnumEnchantmentType.all;
            } else {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, e, e.field_77351_y, "Type");
            }
        }
        try {
            e.func_77320_a();
        }
        catch (Exception ex) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.UNPARSEABLE, e, ex, "Name");
        }
        try {
            e.func_77316_c(1);
        }
        catch (Exception ex) {
            throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.UNPARSEABLE, e, ex, "Localization");
        }
    }

    public void verifyPotion(Potion p) throws EnvironmentSanityException {
        if (p.func_76393_a() == null) {
            if (DragonOptions.FIXSANITY.getState()) {
                p.func_76390_b("NULL");
            } else {
                throw new EnvironmentSanityException(EnvironmentSanityException.ErrorType.INVALIDVALUE, p, p.func_76393_a(), "Name");
            }
        }
    }

    public static String getSafeItemString(ItemStack is) {
        if (is == null) {
            return "null";
        }
        if (is.func_77973_b() == null) {
            return "null-item";
        }
        try {
            return is.toString() + " {" + ReikaItemHelper.getRegistrantMod(is) + "}";
        }
        catch (Exception e) {
            return "[THREW " + e.toString() + "]";
        }
    }
}

