/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Collections.RelativePositionList;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Block.MachineRegistryBlock;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ProgressiveRecursiveBreaker
implements TickRegistry.TickHandler {
    public static final ProgressiveRecursiveBreaker instance = new ProgressiveRecursiveBreaker();
    private static final int MAX_DEPTH = 4;
    private static final int MAX_SIZE = 32000;
    private static final ForgeDirection[] dirs = ForgeDirection.values();
    private final MultiMap<Integer, ProgressiveBreaker> breakers = new MultiMap();

    private ProgressiveRecursiveBreaker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload evt) {
    }

    public void addCoordinate(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        this.addCoordinate(world, x, y, z, Integer.MAX_VALUE);
    }

    public void addCoordinate(World world, ProgressiveBreaker b) {
        if (world.field_72995_K) {
            return;
        }
        this.breakers.addValue(world.field_73011_w.field_76574_g, b);
    }

    public void addCoordinate(World world, int x, int y, int z, TreeType tree) {
        if (world.field_72995_K) {
            return;
        }
        ProgressiveBreaker b = this.getTreeBreaker(world, x, y, z, tree);
        this.breakers.addValue(world.field_73011_w.field_76574_g, b);
    }

    public ProgressiveBreaker getTreeBreaker(World world, int x, int y, int z, TreeType tree) {
        int i;
        if (world.field_72995_K) {
            return null;
        }
        Block log = tree.getLogID();
        Block leaf = tree.getLeafID();
        List<Integer> logmetas = tree.getLogMetadatas();
        List<Integer> leafmetas = tree.getLeafMetadatas();
        ArrayList<BlockKey> ids = new ArrayList<BlockKey>();
        for (i = 0; i < logmetas.size(); ++i) {
            ids.add(new BlockKey(log, logmetas.get(i)));
        }
        for (i = 0; i < leafmetas.size(); ++i) {
            ids.add(new BlockKey(leaf, leafmetas.get(i)));
        }
        int depth = 30;
        if (tree == ModWoodList.SEQUOIA) {
            depth = 350;
        }
        if (tree == ModWoodList.TWILIGHTOAK) {
            depth = 200;
        }
        if (tree == ModWoodList.DARKWOOD) {
            depth = 32;
        }
        ProgressiveBreaker b = new ProgressiveBreaker(world, x, y, z, depth, ids);
        b.extraSpread = true;
        return b;
    }

    public void addCoordinate(World world, int x, int y, int z, List<BlockKey> ids) {
        if (world.field_72995_K) {
            return;
        }
        this.breakers.addValue(world.field_73011_w.field_76574_g, new ProgressiveBreaker(world, x, y, z, Integer.MAX_VALUE, ids));
    }

    public void addCoordinate(World world, int x, int y, int z, int maxDepth) {
        if (world.field_72995_K) {
            return;
        }
        this.breakers.addValue(world.field_73011_w.field_76574_g, new ProgressiveBreaker(world, x, y, z, maxDepth));
    }

    public ProgressiveBreaker addCoordinateWithReturn(World world, int x, int y, int z, int maxDepth) {
        if (world.field_72995_K) {
            return null;
        }
        ProgressiveBreaker b = new ProgressiveBreaker(world, x, y, z, maxDepth);
        this.breakers.addValue(world.field_73011_w.field_76574_g, b);
        return b;
    }

    @Override
    public void tick(TickRegistry.TickType type, Object ... tickData) {
        World world = (World)tickData[0];
        Collection<ProgressiveBreaker> li = this.breakers.get(world.field_73011_w.field_76574_g);
        if (li != null) {
            if (!world.field_72995_K) {
                Iterator<ProgressiveBreaker> it = li.iterator();
                while (it.hasNext()) {
                    ProgressiveBreaker b = it.next();
                    if (b.isDone) {
                        it.remove();
                        continue;
                    }
                    b.tick();
                }
            } else {
                li.clear();
            }
        }
    }

    @Override
    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD);
    }

    @Override
    public String getLabel() {
        return "Progressive Recursive Breaker";
    }

    @Override
    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public void clearBreakers() {
        this.breakers.clear();
    }

    public static interface BreakerCallback {
        public boolean canBreak(ProgressiveBreaker var1, World var2, int var3, int var4, int var5, Block var6, int var7);

        public void onPreBreak(ProgressiveBreaker var1, World var2, int var3, int var4, int var5, Block var6, int var7);

        public void onPostBreak(ProgressiveBreaker var1, World var2, int var3, int var4, int var5, Block var6, int var7);

        public void onFinish(ProgressiveBreaker var1);
    }

    public static final class ProgressiveBreaker {
        private final BlockArray start = new BlockArray();
        private final World world;
        private final int maxDepth;
        private int depth = 0;
        private boolean isDone = false;
        private final HashSet<BlockKey> ids = new HashSet();
        public final HashSet<BlockKey> passthrough = new HashSet();
        public boolean extraSpread = false;
        public int tickRate = 1;
        private int tick;
        public int fortune = 0;
        public boolean silkTouch = false;
        public boolean drops = true;
        public IInventory dropInventory = null;
        public EntityPlayer player;
        public float hungerFactor = 1.0f;
        public BlockBox bounds = BlockBox.infinity();
        public BreakerCallback call;
        public boolean isOmni = false;
        private boolean isBlacklist = false;
        public boolean pathTracking = false;
        public boolean dropFluids = true;
        public boolean breakAir = false;
        private final Collection<Coordinate> path = new HashSet<Coordinate>();
        public boolean taxiCabDistance = false;
        public final int originX;
        public final int originY;
        public final int originZ;
        public boolean causeUpdates = true;

        private ProgressiveBreaker(World world, int x, int y, int z, int depth, List<BlockKey> ids) {
            this.world = world;
            this.start.addBlockCoordinate(x, y, z);
            this.maxDepth = depth;
            this.ids.addAll(ids);
            this.originX = x;
            this.originY = y;
            this.originZ = z;
        }

        private ProgressiveBreaker(World world, int x, int y, int z, int depth, BlockKey ... ids) {
            this.world = world;
            this.start.addBlockCoordinate(x, y, z);
            this.maxDepth = depth;
            for (int i = 0; i < ids.length; ++i) {
                this.ids.add(ids[i]);
            }
            this.originX = x;
            this.originY = y;
            this.originZ = z;
        }

        private ProgressiveBreaker(World world, int x, int y, int z, Block id, int depth) {
            this.world = world;
            this.start.addBlockCoordinate(x, y, z);
            this.maxDepth = depth;
            for (int i = 0; i < 16; ++i) {
                this.ids.add(new BlockKey(id, i));
            }
            this.originX = x;
            this.originY = y;
            this.originZ = z;
        }

        private ProgressiveBreaker(World world, int x, int y, int z, Block id, int meta, int depth) {
            this.world = world;
            this.start.addBlockCoordinate(x, y, z);
            this.maxDepth = depth;
            this.ids.add(new BlockKey(id, meta));
            this.originX = x;
            this.originY = y;
            this.originZ = z;
        }

        private ProgressiveBreaker(World world, int x, int y, int z, int depth) {
            this(world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z), depth);
        }

        public void addBlock(BlockKey bk) {
            this.ids.add(bk);
        }

        public void setBlacklist(BlockKey ... keys) {
            this.ids.clear();
            this.isBlacklist = true;
            for (int i = 0; i < keys.length; ++i) {
                this.ids.add(keys[i]);
            }
        }

        private void tick() {
            ++this.tick;
            if (this.tick < this.tickRate) {
                return;
            }
            this.tick = 0;
            if (this.depth < this.maxDepth) {
                int z;
                int y;
                int x;
                Coordinate c;
                int i;
                BlockArray next = new BlockArray();
                for (i = 0; i < this.start.getSize() && !this.isDone; ++i) {
                    int dz;
                    int dy;
                    int dx;
                    c = this.start.getNthBlock(i);
                    x = c.xCoord;
                    y = c.yCoord;
                    z = c.zCoord;
                    Block b = this.world.func_147439_a(x, y, z);
                    if (b == Blocks.field_150350_a && !this.breakAir) continue;
                    int meta = this.world.func_72805_g(x, y, z);
                    if (this.call != null && !this.call.canBreak(this, this.world, x, y, z, b, meta)) continue;
                    for (int k = 0; k < 6; ++k) {
                        ForgeDirection dir = dirs[k];
                        dx = x + dir.offsetX;
                        dy = y + dir.offsetY;
                        dz = z + dir.offsetZ;
                        if (!this.canSpreadTo(this.world, dx, dy, dz)) continue;
                        next.addBlockCoordinate(dx, dy, dz);
                    }
                    if (this.extraSpread) {
                        for (int n = 0; n < RelativePositionList.cornerDirections.getSize(); ++n) {
                            Coordinate d = RelativePositionList.cornerDirections.getNthPosition(x, y, z, n);
                            dx = d.xCoord;
                            dy = d.yCoord;
                            dz = d.zCoord;
                            if (!this.canSpreadTo(this.world, dx, dy, dz)) continue;
                            next.addBlockCoordinate(dx, dy, dz);
                        }
                    }
                    if (this.pathTracking) {
                        this.path.add(new Coordinate(x, y, z));
                    }
                    this.dropBlock(this.world, x, y, z);
                }
                this.start.clear();
                for (i = 0; i < next.getSize() && i < 32000; ++i) {
                    c = next.getNthBlock(i);
                    x = c.xCoord;
                    y = c.yCoord;
                    z = c.zCoord;
                    this.start.addBlockCoordinate(x, y, z);
                }
                ++this.depth;
                if (this.start.isEmpty()) {
                    this.finish();
                }
            } else {
                this.finish();
            }
        }

        private void finish() {
            this.isDone = true;
            if (this.call != null) {
                this.call.onFinish(this);
            }
        }

        public void terminate() {
            this.finish();
        }

        private boolean canSpreadTo(World world, int x, int y, int z) {
            BlockKey bk;
            if (this.taxiCabDistance && Math.abs(x - this.originX) + Math.abs(y - this.originY) + Math.abs(z - this.originZ) > this.maxDepth) {
                return false;
            }
            if (this.pathTracking && this.path.contains(new Coordinate(x, y, z))) {
                return false;
            }
            if (!this.bounds.isBlockInside(x, y, z)) {
                return false;
            }
            Block id = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (id == Blocks.field_150350_a && !this.breakAir) {
                return false;
            }
            if (!(this.isOmni || this.ids.contains(bk = new BlockKey(id, meta)) || this.passthrough.contains(bk))) {
                return false;
            }
            return this.player == null || !world.field_72995_K && ReikaPlayerAPI.playerCanBreakAt((WorldServer)world, x, y, z, (EntityPlayerMP)this.player);
        }

        private void dropBlock(World world, int x, int y, int z) {
            int meta;
            Block id = world.func_147439_a(x, y, z);
            boolean pass = this.passthrough.contains(new BlockKey(id, meta = world.func_72805_g(x, y, z)));
            if (!pass && id != Blocks.field_150350_a) {
                if (this.drops) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    if (id instanceof BlockTieredResource) {
                        BlockTieredResource bt = (BlockTieredResource)id;
                        if (this.player != null) {
                            if (bt.isPlayerSufficientTier((IBlockAccess)world, x, y, z, this.player)) {
                                drops.addAll(bt.getHarvestResources(world, x, y, z, this.fortune, this.player));
                            } else {
                                drops.addAll(bt.getNoHarvestResources(world, x, y, z, this.fortune, this.player));
                            }
                        }
                    } else if (id instanceof MachineRegistryBlock) {
                        drops.add(((MachineRegistryBlock)id).getMachine((IBlockAccess)world, x, y, z).getCraftedProduct(world.func_147438_o(x, y, z)));
                    } else if (this.silkTouch && id.canSilkHarvest(world, this.player, x, y, z, meta)) {
                        ItemStack silk = ReikaBlockHelper.getSilkTouch(world, x, y, z, id, meta, this.player, this.dropFluids);
                        if (silk != null) {
                            drops.add(silk);
                        } else {
                            drops.addAll(ReikaWorldHelper.getDropsAt(world, x, y, z, this.fortune, this.player));
                        }
                    } else {
                        drops.addAll(ReikaWorldHelper.getDropsAt(world, x, y, z, this.fortune, this.player));
                    }
                    for (ItemStack is : drops) {
                        boolean flag = false;
                        if (this.dropInventory != null) {
                            if (this.dropInventory instanceof InventoryPlayer && MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(((InventoryPlayer)this.dropInventory).field_70458_d, new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, is)))) continue;
                            flag = ReikaInventoryHelper.addToIInv(is, this.dropInventory);
                        }
                        if (flag) continue;
                        ReikaItemHelper.dropItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, is);
                    }
                }
                if (ReikaBlockHelper.isLiquid(id)) {
                    if (id.func_149688_o() == Material.field_151586_h) {
                        ReikaSoundHelper.playSoundAtBlock(world, x, y, z, "game.neutral.swim");
                    } else {
                        ReikaSoundHelper.playSoundAtBlock(world, x, y, z, "mob.ghast.fireball");
                    }
                } else {
                    ReikaSoundHelper.playBreakSound(world, x, y, z, id);
                }
            }
            if (this.call != null) {
                this.call.onPreBreak(this, world, x, y, z, id, meta);
            }
            if (!pass && id != Blocks.field_150350_a) {
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, this.causeUpdates ? 3 : 2);
            }
            if (!pass && this.causeUpdates) {
                world.func_147471_g(x, y, z);
            }
            if (!pass && this.player != null) {
                this.player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)id)], 1);
                this.player.func_71020_j(0.025f * this.hungerFactor);
            }
            if (this.call != null) {
                this.call.onPostBreak(this, world, x, y, z, id, meta);
            }
        }
    }
}

