/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Extras.ReikaShader;
import Reika.DragonAPI.IO.Shaders.ShaderRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.VillageBuilding;
import Reika.DragonAPI.Interfaces.Block.CollisionDelegate;
import Reika.DragonAPI.Interfaces.Block.CustomSnowAccumulation;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Interfaces.Item.MetadataSpecificTrade;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ASMCalls {
    public static void onCallChunkRenderLists(RenderGlobal rg, int pass, double ptick) {
        rg.func_72733_a(pass, ptick);
    }

    public static void onRenderWorld(EntityRenderer er, float ptick, long systime) {
        er.func_78471_a(ptick, systime);
        Minecraft mc = Minecraft.func_71410_x();
        ReikaShader.instance.render(mc);
        ShaderRegistry.runShaderDomain(mc.func_147110_a(), mc.field_71443_c, mc.field_71440_d, ShaderRegistry.ShaderDomain.GLOBALNOGUI);
    }

    public static void onRenderFrameBuffer(Framebuffer fb, int w, int h) {
        ShaderRegistry.runShaderDomain(fb, w, h, ShaderRegistry.ShaderDomain.GLOBAL);
        ReikaRenderHelper.setRenderTarget(null);
        fb.func_147615_c(w, h);
    }

    public static HashMap<Character, Object> parseItemMappings(int i, boolean ore, Object[] in) {
        HashMap<Character, Object> ret = new HashMap<Character, Object>();
        while (i < in.length) {
            Character c = (Character)in[i];
            Object o = in[i + 1];
            if (o != null) {
                Object is = null;
                if (ore && o instanceof String) {
                    is = OreDictionary.getOres((String)((String)o));
                }
                if (is == null) {
                    is = ReikaItemHelper.parseItem(o);
                }
                if (is == null) {
                    throw new IllegalArgumentException("Invalid ingredient object type " + o.getClass() + " with value " + o.toString() + " for char " + c);
                }
                ret.put(c, is);
            }
            i += 2;
        }
        return ret;
    }

    public static MerchantRecipe getMatchingTrade(MerchantRecipeList li, ItemStack is1, ItemStack is2, int idx) {
        if (idx > 0 && idx < li.size()) {
            MerchantRecipe rec = (MerchantRecipe)li.get(idx);
            return ASMCalls.matchFirst(rec, is1) && ASMCalls.matchSecond(rec, is2) ? rec : null;
        }
        for (int j = 0; j < li.size(); ++j) {
            MerchantRecipe ret = (MerchantRecipe)li.get(j);
            if (!ASMCalls.matchFirst(ret, is1) || !ASMCalls.matchSecond(ret, is2)) continue;
            return ret;
        }
        return null;
    }

    private static boolean matchFirst(MerchantRecipe rec, ItemStack is1) {
        return ASMCalls.matchItem(rec.func_77394_a(), is1);
    }

    private static boolean matchSecond(MerchantRecipe rec, ItemStack is2) {
        if (rec.func_77396_b() == null) {
            return is2 == null;
        }
        return is2 != null && ASMCalls.matchItem(rec.func_77396_b(), is2);
    }

    private static boolean matchItem(ItemStack a, ItemStack b) {
        return a.func_77973_b() == b.func_77973_b() && b.field_77994_a >= a.field_77994_a && (!(a.func_77973_b() instanceof MetadataSpecificTrade) && !(b.func_77973_b() instanceof MetadataSpecificTrade) || a.func_77960_j() == b.func_77960_j());
    }

    public static void preTessellatorStart() {
        GL11.glAlphaFunc((int)518, (float)0.007843138f);
    }

    public static List buildVillageStructureList(Random rand, int val, MapGenVillage.Start s) {
        ArrayList<StructureVillagePieces.PieceWeight> li = new ArrayList<StructureVillagePieces.PieceWeight>();
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House4Garden.class, 4, MathHelper.func_76136_a((Random)rand, (int)(2 + val), (int)(4 + val * 2))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Church.class, 20, MathHelper.func_76136_a((Random)rand, (int)(0 + val), (int)(1 + val))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House1.class, 20, MathHelper.func_76136_a((Random)rand, (int)(0 + val), (int)(2 + val))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.WoodHut.class, 3, MathHelper.func_76136_a((Random)rand, (int)(2 + val), (int)(5 + val * 3))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Hall.class, 15, MathHelper.func_76136_a((Random)rand, (int)(0 + val), (int)(2 + val))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Field1.class, 3, MathHelper.func_76136_a((Random)rand, (int)(1 + val), (int)(4 + val))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Field2.class, 3, MathHelper.func_76136_a((Random)rand, (int)(2 + val), (int)(4 + val * 2))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House2.class, 15, MathHelper.func_76136_a((Random)rand, (int)0, (int)(1 + val))));
        li.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House3.class, 8, MathHelper.func_76136_a((Random)rand, (int)(0 + val), (int)(3 + val * 2))));
        VillagerRegistry.addExtraVillageComponents(li, (Random)rand, (int)val);
        Iterator it = li.iterator();
        while (it.hasNext()) {
            StructureVillagePieces.PieceWeight pw = (StructureVillagePieces.PieceWeight)it.next();
            if (pw.field_75087_d == 0) {
                it.remove();
                continue;
            }
            if (!(pw instanceof VillageBuilding.PerVillageWeight) || ((VillageBuilding.PerVillageWeight)pw).canGenerate(s)) continue;
            it.remove();
        }
        return li;
    }

    public static boolean isGitFile(File f) {
        return f.getName().contains(".git");
    }

    public static ChunkPosition getStrongholdSeekPos(StructureStrongholdPieces.Stairs2 struct) {
        if (struct == null) {
            DragonAPICore.logError("Cannot get the stronghold position for a null structure!");
            return null;
        }
        if (struct.field_75025_b == null) {
            DragonAPICore.log("Structure has no portal!");
            return new ChunkPosition(struct.func_74874_b().func_78881_e(), struct.func_74874_b().func_78879_f(), struct.func_74874_b().func_78891_g());
        }
        return DragonOptions.REROUTEEYES.getState() ? new ChunkPosition(struct.func_74874_b().func_78881_e(), struct.func_74874_b().func_78879_f(), struct.func_74874_b().func_78891_g()) : struct.field_75025_b.func_151553_a();
    }

    public static boolean canSnowAccumulate(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) {
            return false;
        }
        if (block.isLeaves((IBlockAccess)world, x, y - 1, z)) {
            return true;
        }
        if (block == Blocks.field_150431_aC) {
            return (world.func_72805_g(x, y - 1, z) & 7) == 7;
        }
        if (block instanceof CustomSnowAccumulation) {
            return ((CustomSnowAccumulation)block).canSnowAccumulate(world, x, y - 1, z);
        }
        return block.func_149688_o().func_76230_c() && block.isSideSolid((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP);
    }

    public static void registerPermutedBiomesToDictionary() {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (!(b instanceof BiomeGenMutated)) continue;
            BiomeGenBase parent = ((BiomeGenMutated)b).field_150611_aD;
            BiomeDictionary.registerBiomeType((BiomeGenBase)b, (BiomeDictionary.Type[])BiomeDictionary.getTypesForBiome((BiomeGenBase)parent));
        }
    }

    public static boolean handleLavaMovement(Entity e) {
        AxisAlignedBB box = e.field_70121_D.func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
        World world = e.field_70170_p;
        int x0 = MathHelper.func_76128_c((double)box.field_72340_a);
        int x1 = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0));
        int y0 = MathHelper.func_76128_c((double)box.field_72338_b);
        int y1 = MathHelper.func_76128_c((double)(box.field_72337_e + 1.0));
        int z0 = MathHelper.func_76128_c((double)box.field_72339_c);
        int z1 = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0));
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                for (int z = z0; z < z1; ++z) {
                    Fluid f;
                    int dx = x;
                    int dy = y;
                    int dz = z;
                    Block b = world.func_147439_a(x, y, z);
                    if (b instanceof CollisionDelegate) {
                        Coordinate c = ((CollisionDelegate)b).getDelegatedCollision(world, x, y, z);
                        b = c.getBlock((IBlockAccess)world);
                        dx = c.xCoord;
                        dy = c.yCoord;
                        dz = c.zCoord;
                    }
                    if ((f = FluidRegistry.lookupFluidForBlock((Block)b)) != FluidRegistry.LAVA && (f == null || f.getTemperature(world, dx, dy, dz) < FluidRegistry.LAVA.getTemperature(world, dx, dy, dz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean allowMobSleeping(List<EntityMob> li) {
        for (EntityMob e : li) {
            if (e instanceof TameHostile) continue;
            return false;
        }
        return true;
    }
}

