/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modules.ComputerScreenModule;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class ScreenControllerTileEntity
extends GenericEnergyReceiverTileEntity
implements SimpleComponent,
IPeripheral {
    public static final String CMD_SCAN = "scan";
    public static final String CMD_DETACH = "detach";
    public static final String COMPONENT_NAME = "screen_controller";
    private List<Coordinate> connectedScreens = new ArrayList<Coordinate>();
    private int tickCounter = 20;

    public ScreenControllerTileEntity() {
        super(ScreenConfiguration.CONTROLLER_MAXENERGY, ScreenConfiguration.CONTROLLER_RECEIVEPERTICK);
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getScreenCount", "getScreenIndex", "getScreenCoordinate", "addText", "setText", "clearText"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.connectedScreens.size()};
            }
            case 1: {
                return this.getScreenIndex(new Coordinate(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue()));
            }
            case 2: {
                Coordinate c = this.connectedScreens.get(((Double)arguments[0]).intValue());
                return new Object[]{c.getX(), c.getY(), c.getZ()};
            }
            case 3: {
                return this.addText((String)arguments[0], (String)arguments[1], ((Double)arguments[2]).intValue());
            }
            case 4: {
                return this.setText((String)arguments[0], (String)arguments[1], ((Double)arguments[2]).intValue());
            }
            case 5: {
                return this.clearText((String)arguments[0]);
            }
        }
        return new Object[0];
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Get the amount of screens controlled by this controller", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getScreenCount(Context context, Arguments args) throws Exception {
        return new Object[]{this.connectedScreens.size()};
    }

    @Callback(doc="Get a table with coordinates (every coordinate is a table indexed with 'x', 'y', and 'z') for all connected screens", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getScreens(Context context, Arguments args) throws Exception {
        ArrayList result = new ArrayList();
        for (Coordinate screen : this.connectedScreens) {
            HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
            coordinate.put("x", screen.getX());
            coordinate.put("y", screen.getY());
            coordinate.put("z", screen.getZ());
            result.add(coordinate);
        }
        return new Object[]{result};
    }

    @Callback(doc="Given a screen coordinate (table indexed by 'x', 'y', and 'z') return the index of that screen", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getScreenIndex(Context context, Arguments args) throws Exception {
        Map screen = args.checkTable(0);
        if (!(screen.containsKey("x") && screen.containsKey("y") && screen.containsKey("z"))) {
            throw new IllegalArgumentException("Screen map doesn't contain the right x,y,z coordinate!");
        }
        Coordinate recC = new Coordinate(((Double)screen.get("x")).intValue(), ((Double)screen.get("y")).intValue(), ((Double)screen.get("z")).intValue());
        return this.getScreenIndex(recC);
    }

    private Object[] getScreenIndex(Coordinate coordinate) {
        int i = 0;
        for (Coordinate connectedScreen : this.connectedScreens) {
            if (connectedScreen.equals((Object)coordinate)) {
                return new Object[]{i};
            }
            ++i;
        }
        return null;
    }

    @Callback(doc="Given a screen index return the coordinate (table indexed by 'x', 'y', and 'z') of that screen", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getScreenCoordinate(Context context, Arguments args) throws Exception {
        int index = args.checkInteger(0);
        if (index < 0 || index >= this.connectedScreens.size()) {
            throw new IllegalArgumentException("Screen index out of range!");
        }
        Coordinate screen = this.connectedScreens.get(index);
        HashMap<String, Integer> coordinate = new HashMap<String, Integer>();
        coordinate.put("x", screen.getX());
        coordinate.put("y", screen.getY());
        coordinate.put("z", screen.getZ());
        return new Object[]{coordinate};
    }

    @Callback(doc="Add text to all screens listening to the given 'tag'. Parameters are: 'tag', 'text' and 'color' (RGB value)")
    @Optional.Method(modid="OpenComputers")
    public Object[] addText(Context context, Arguments args) throws Exception {
        String tag = args.checkString(0);
        String text = args.checkString(1);
        int color = args.checkInteger(2);
        return this.addText(tag, text, color);
    }

    @Callback(doc="Set text to all screens listening to the given 'tag'. Parameters are: 'tag', 'text' and 'color' (RGB value)")
    @Optional.Method(modid="OpenComputers")
    public Object[] setText(Context context, Arguments args) throws Exception {
        String tag = args.checkString(0);
        String text = args.checkString(1);
        int color = args.checkInteger(2);
        this.clearText(tag);
        return this.addText(tag, text, color);
    }

    private Object[] setText(String tag, String text, int color) {
        this.clearText(tag);
        return this.addText(tag, text, color);
    }

    private Object[] addText(String tag, String text, int color) {
        for (Coordinate screen : this.connectedScreens) {
            ScreenTileEntity screenTileEntity;
            List<ComputerScreenModule> computerScreenModules;
            TileEntity te = this.field_145850_b.func_147438_o(screen.getX(), screen.getY(), screen.getZ());
            if (!(te instanceof ScreenTileEntity) || (computerScreenModules = (screenTileEntity = (ScreenTileEntity)te).getComputerModules(tag)) == null) continue;
            for (ComputerScreenModule screenModule : computerScreenModules) {
                screenModule.addText(text, color);
            }
        }
        return null;
    }

    @Callback(doc="Clear text to all screens listening to the given 'tag'. The 'tag' is the only parameter")
    @Optional.Method(modid="OpenComputers")
    public Object[] clearText(Context context, Arguments args) throws Exception {
        String tag = args.checkString(0);
        return this.clearText(tag);
    }

    private Object[] clearText(String tag) {
        for (Coordinate screen : this.connectedScreens) {
            ScreenTileEntity screenTileEntity;
            List<ComputerScreenModule> computerScreenModules;
            TileEntity te = this.field_145850_b.func_147438_o(screen.getX(), screen.getY(), screen.getZ());
            if (!(te instanceof ScreenTileEntity) || (computerScreenModules = (screenTileEntity = (ScreenTileEntity)te).getComputerModules(tag)) == null) continue;
            for (ComputerScreenModule screenModule : computerScreenModules) {
                screenModule.clearText();
            }
        }
        return null;
    }

    @Callback(doc="Get a table of all tags supported by all connected screens", getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTags(Context context, Arguments args) throws Exception {
        ArrayList<String> tags = new ArrayList<String>();
        for (Coordinate screen : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_147438_o(screen.getX(), screen.getY(), screen.getZ());
            if (!(te instanceof ScreenTileEntity)) continue;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
            tags.addAll(screenTileEntity.getTags());
        }
        return new Object[]{tags};
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int[] xes = tagCompound.func_74759_k("screensx");
        int[] yes = tagCompound.func_74759_k("screensy");
        int[] zes = tagCompound.func_74759_k("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new Coordinate(xes[i], yes[i], zes[i]));
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            Coordinate c = this.connectedScreens.get(i);
            xes[i] = c.getX();
            yes[i] = c.getY();
            zes[i] = c.getZ();
        }
        tagCompound.func_74783_a("screensx", xes);
        tagCompound.func_74783_a("screensy", yes);
        tagCompound.func_74783_a("screensz", zes);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
    }

    protected void checkStateServer() {
        int rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        int rememberRf = rf = this.getEnergyStored(ForgeDirection.DOWN);
        boolean fixesAreNeeded = false;
        for (Coordinate c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
                int rfModule = screenTileEntity.getTotalRfPerTick() * 20;
                if (rfModule > rf) {
                    screenTileEntity.setPower(false);
                    continue;
                }
                rf -= rfModule;
                screenTileEntity.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<Coordinate> newScreens = new ArrayList<Coordinate>();
            for (Coordinate c : this.connectedScreens) {
                TileEntity te = this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void scan() {
        this.detach();
        int radius = 32 + (int)(this.getInfusedFactor() * 32.0f);
        for (int y = this.field_145848_d - 16; y <= this.field_145848_d + 16; ++y) {
            if (y < 0 || y >= 256) continue;
            for (int x = this.field_145851_c - radius; x <= this.field_145851_c + radius; ++x) {
                for (int z = this.field_145849_e - radius; z <= this.field_145849_e + radius; ++z) {
                    TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                    if (!(te instanceof ScreenTileEntity) || ((ScreenTileEntity)te).isConnected()) continue;
                    this.connectedScreens.add(new Coordinate(x, y, z));
                    ((ScreenTileEntity)te).setConnected(true);
                }
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void detach() {
        for (Coordinate c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
            if (!(te instanceof ScreenTileEntity)) continue;
            ((ScreenTileEntity)te).setPower(false);
            ((ScreenTileEntity)te).setConnected(false);
        }
        this.connectedScreens.clear();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public List<Coordinate> getConnectedScreens() {
        return this.connectedScreens;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SCAN.equals(command)) {
            this.scan();
            return true;
        }
        if (CMD_DETACH.equals(command)) {
            this.detach();
            return true;
        }
        return false;
    }
}

