/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.item.GatewayElectricItemManager;
import ic2.core.item.armor.ItemArmorJetpack;
import ic2.core.util.StackUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.opengl.GL11;

public class ChargeTooltipHandler {
    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent evt) {
        String tooltip;
        if (evt.itemStack == null) {
            return;
        }
        IElectricItemManager manager = ((GatewayElectricItemManager)ElectricItem.manager).getManager(evt.itemStack);
        if (manager != null && (tooltip = manager.getToolTip(evt.itemStack)) != null) {
            evt.toolTip.add(tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post evt) {
        RenderGameOverlayEvent.ElementType cfr_ignored_0 = evt.type;
        if (evt.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack item = player.field_71071_by.field_70460_b[2];
        if (item == null || !(item.func_77973_b() instanceof ItemArmorJetpack)) {
            return;
        }
        ItemArmorJetpack pack = (ItemArmorJetpack)item.func_77973_b();
        if (!pack.canDoRocketMode()) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        if (!nbt.func_74767_n("RocketMode")) {
            return;
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int maxCharge = pack.getMaxRocketCharge();
        int charge = nbt.func_74762_e("UsedEnergy");
        float scale = (float)charge / (float)maxCharge;
        FontRenderer fontrenderer = mc.field_71466_p;
        ScaledResolution scaledresolution = evt.resolution;
        int i = scaledresolution.func_78326_a();
        int short1 = 182;
        int j = i / 2 - short1 / 2;
        int k = (int)(scale * (float)(short1 + 1));
        int b0 = 211;
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        this.drawTexturedModalRect(j, b0, 0, 74, short1, 5, 0);
        if (k > 0) {
            this.drawTexturedModalRect(j, b0, 0, 79, k, 5, 0);
        }
        String s = StatCollector.func_74838_a((String)"itemInfo.rocketCharge.name");
        fontrenderer.func_78261_a(s, i / 2 - fontrenderer.func_78256_a(s) / 2, b0 - 2, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78381_a();
    }
}

