/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.event.PaintEvent;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.audio.PositionSpec;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemToolPainter
extends ItemIC2 {
    public static HashMap<ChunkCoordIntPair, Integer> dyes = new HashMap();
    public int color;

    public ItemToolPainter(int col) {
        super(128);
        this.func_77656_e(32);
        this.func_77625_d(1);
        this.color = col;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IIcon func_77617_a(int i) {
        return Ic2Icons.getTexture("i0")[this.iconIndex + this.color];
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        PaintEvent event = new PaintEvent(world, i, j, k, side, this.color);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.painted) {
            if (IC2.platform.isSimulating()) {
                this.damagePainter(entityplayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/Painter.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        Block blockId = world.func_147439_a(i, j, k);
        if (blockId != null && blockId.recolourBlock(world, i, j, k, ForgeDirection.getOrientation((int)side), BlockColored.func_150031_c((int)this.color))) {
            if (IC2.platform.isSimulating()) {
                this.damagePainter(entityplayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityplayer, PositionSpec.Hand, "Tools/Painter.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        return false;
    }

    @SubscribeEvent
    public boolean onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Entity entity = event.entity;
        if (entity.field_70170_p.field_72995_K || player.func_71045_bC() == null || player.func_71045_bC().func_77973_b() != this) {
            return true;
        }
        boolean ret = true;
        if (entity instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)entity;
            int clr = BlockColored.func_150031_c((int)this.color);
            if (sheep.func_70896_n() != clr) {
                ret = false;
                ((EntitySheep)entity).func_70891_b(clr);
                this.damagePainter(player);
            }
        }
        return ret;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            boolean newValue = !nbtData.func_74767_n("autoRefill");
            nbtData.func_74757_a("autoRefill", newValue);
            if (newValue) {
                IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.painterAutoRefillEnabled.name"));
            } else {
                IC2.platform.messagePlayer(entityplayer, StatCollector.func_74838_a((String)"itemInfo.painterAutoRefillDisabled.name"));
            }
        }
        return itemstack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean debugTooltips) {
        info.add(StatCollector.func_74838_a((String)(Items.field_151100_aR.func_77667_c(new ItemStack(Items.field_151100_aR, 1, this.color)) + ".name")));
    }

    private void damagePainter(EntityPlayer player) {
        if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77960_j() >= player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77958_k() - 1) {
            int dyeIS = -1;
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c]);
            if (nbtData.func_74767_n("autoRefill")) {
                for (int l = 0; l < player.field_71071_by.field_70462_a.length; ++l) {
                    ChunkCoordIntPair ip;
                    if (player.field_71071_by.field_70462_a[l] == null || !dyes.containsKey(ip = new ChunkCoordIntPair(Item.func_150891_b((Item)player.field_71071_by.field_70462_a[l].func_77973_b()), player.field_71071_by.field_70462_a[l].func_77960_j())) || dyes.get(ip) != this.color) continue;
                    dyeIS = l;
                    break;
                }
            }
            if (dyeIS == -1) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = Ic2Items.painter.func_77946_l();
            } else {
                ItemStack itemStack = player.field_71071_by.field_70462_a[dyeIS];
                --itemStack.field_77994_a;
                if (player.field_71071_by.field_70462_a[dyeIS].field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[dyeIS] = null;
                }
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77964_b(0);
            }
        } else {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].func_77972_a(1, (EntityLivingBase)player);
        }
        player.field_71070_bA.func_75142_b();
    }
}

