/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityLuminator;
import ic2.core.util.Util;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCable
extends TileEntityBlock
implements IEnergyConductorColored,
INetworkTileEntityEventListener {
    public short cableType = 0;
    public short color = 0;
    public byte foamed = 0;
    public byte foamColor = 0;
    public boolean addedToEnergyNet = false;
    public byte[] connections = new byte[6];
    private static int EventRemoveConductor = 0;

    public TileEntityCable(short type) {
        this.cableType = type;
    }

    public TileEntityCable() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.cableType = nbttagcompound.func_74765_d("cableType");
        this.color = nbttagcompound.func_74765_d("color");
        this.foamColor = nbttagcompound.func_74771_c("foamColor");
        byte wasFoamed = nbttagcompound.func_74771_c("foamed");
        if (wasFoamed == 1) {
            this.changeFoam(wasFoamed, true);
        } else {
            this.foamed = wasFoamed;
        }
        byte[] connect = nbttagcompound.func_74770_j("Connections");
        if (connect.length != 6) {
            connect = new byte[6];
        }
        this.connections = connect;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("cableType", this.cableType);
        nbttagcompound.func_74777_a("color", this.color);
        nbttagcompound.func_74774_a("foamed", this.foamed);
        nbttagcompound.func_74774_a("foamColor", this.foamColor);
        nbttagcompound.func_74773_a("Connections", this.connections);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean changeColor(int newColor) {
        if (this.foamed == 0 && (this.color == newColor || this.cableType == 1 || this.cableType == 2 || this.cableType == 5 || this.cableType == 10 || this.cableType == 11 || this.cableType == 12) || this.foamed > 0 && this.foamColor == newColor) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            if (this.foamed == 0) {
                if (this.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
                }
                this.addedToEnergyNet = false;
                this.color = (short)newColor;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
                IC2.network.get().updateTileEntityField(this, "color");
            } else {
                this.foamColor = (byte)newColor;
                IC2.network.get().updateTileEntityField(this, "foamColor");
            }
        }
        return true;
    }

    public boolean changeFoam(byte foamed) {
        return this.changeFoam(foamed, false);
    }

    public boolean tryAddInsulation() {
        short target = 0;
        switch (this.cableType) {
            case 1: {
                target = 0;
                break;
            }
            case 2: {
                target = 3;
                break;
            }
            case 3: {
                target = 4;
                break;
            }
            case 5: {
                target = 6;
                break;
            }
            case 6: {
                target = 7;
                break;
            }
            case 7: {
                target = 8;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public boolean tryRemoveInsulation() {
        short target = 0;
        switch (this.cableType) {
            case 0: {
                target = 1;
                break;
            }
            case 3: {
                target = 2;
                break;
            }
            case 4: {
                target = 3;
                break;
            }
            case 6: {
                target = 5;
                break;
            }
            case 7: {
                target = 6;
                break;
            }
            case 8: {
                target = 7;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public void changeType(short cableType) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)cableType, 3);
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.cableType = cableType;
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        IC2.network.get().updateTileEntityField(this, "cableType");
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.canConnect(direction.ordinal());
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.canConnect(direction.ordinal());
    }

    public boolean canInteractWith(TileEntity te, ForgeDirection dir) {
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof IEnergyConductorColored) {
            return this.canInteractWithAPICable((IEnergyConductorColored)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).canCableConnectFrom(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (te instanceof IEnergyAcceptor && !(te instanceof IEnergyEmitter)) {
            return ((IEnergyAcceptor)te).acceptsEnergyFrom(this, dir.getOpposite());
        }
        if (te instanceof IEnergyEmitter && !(te instanceof IEnergyAcceptor)) {
            return ((IEnergyEmitter)te).emitsEnergyTo(this, dir.getOpposite());
        }
        if (te instanceof IEnergyAcceptor && te instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)te).emitsEnergyTo(this, dir.getOpposite()) || ((IEnergyAcceptor)te).acceptsEnergyFrom(this, dir.getOpposite());
        }
        return te instanceof IMetaDelegate || te instanceof INetworkTileEntityEventListener;
    }

    public boolean canInteractWithAPICable(IEnergyConductorColored cable) {
        return this.color == 0 || cable.getConductorColor() == 0 || this.color == cable.getConductorColor();
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.color == 0 || cable.color == 0 || this.color == cable.color;
    }

    public float getCableThickness() {
        if (this.foamed == 2) {
            return 1.0f;
        }
        return TileEntityCable.getCableThickness(this.cableType);
    }

    public static float getCableThickness(int cableType) {
        float p = 1.0f;
        switch (cableType) {
            case 0: {
                p = 6.0f;
                break;
            }
            case 1: {
                p = 4.0f;
                break;
            }
            case 2: {
                p = 3.0f;
                break;
            }
            case 3: {
                p = 5.0f;
                break;
            }
            case 4: {
                p = 6.0f;
                break;
            }
            case 5: {
                p = 6.0f;
                break;
            }
            case 6: {
                p = 8.0f;
                break;
            }
            case 7: {
                p = 10.0f;
                break;
            }
            case 8: {
                p = 12.0f;
                break;
            }
            case 9: {
                p = 4.0f;
                break;
            }
            case 10: {
                p = 5.0f;
                break;
            }
            case 11: {
                p = 8.0f;
                break;
            }
            case 12: {
                p = 8.0f;
                break;
            }
            case 13: {
                p = 16.0f;
            }
        }
        return p / 16.0f;
    }

    @Override
    public double getConductionLoss() {
        switch (this.cableType) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.5;
            }
            case 3: {
                return 0.45;
            }
            case 4: {
                return 0.4;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 0.95;
            }
            case 7: {
                return 0.9;
            }
            case 8: {
                return 0.8;
            }
            case 9: {
                return 0.025;
            }
            case 10: {
                return 0.025;
            }
            case 11: {
                return 0.5;
            }
            case 12: {
                return 0.5;
            }
        }
        return 0.025;
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        switch (this.cableType) {
            case 0: {
                return 32.0;
            }
            case 1: {
                return 8.0;
            }
            case 2: {
                return 8.0;
            }
            case 3: {
                return 32.0;
            }
            case 4: {
                return 128.0;
            }
            case 5: {
                return 0.0;
            }
            case 6: {
                return 128.0;
            }
            case 7: {
                return 512.0;
            }
            case 8: {
                return 9001.0;
            }
            case 9: {
                return 9001.0;
            }
            case 10: {
                return 3.0;
            }
            case 11: {
                return 9001.0;
            }
            case 12: {
                return 9001.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        return 9001.0;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        switch (this.cableType) {
            case 0: {
                return 33.0;
            }
            case 1: {
                return 33.0;
            }
            case 2: {
                return 129.0;
            }
            case 3: {
                return 129.0;
            }
            case 4: {
                return 129.0;
            }
            case 5: {
                return 2049.0;
            }
            case 6: {
                return 2049.0;
            }
            case 7: {
                return 2049.0;
            }
            case 8: {
                return 2049.0;
            }
            case 9: {
                return 513.0;
            }
            case 10: {
                return 6.0;
            }
            case 11: {
                return 2049.0;
            }
            case 12: {
                return 2049.0;
            }
        }
        return 0.0;
    }

    @Override
    public void removeInsulation() {
    }

    @Override
    public void removeConductor() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        IC2.network.get().initiateTileEntityEvent(this, 0, true);
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>();
        ret.add("cableType");
        ret.add("color");
        ret.add("foamed");
        ret.add("foamColor");
        ret.add("connections");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("cableType") || field.equals("color") || field.equals("foamed") || field.equals("foamColor") || field.equals("connections")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.fizz", 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + 1.2, (double)this.field_145849_e + Math.random(), 0.0, 0.0, 0.0);
                }
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ")");
            }
        }
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    private boolean changeFoam(byte foamed, boolean duringLoad) {
        if (this.foamed == foamed) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            this.foamed = foamed;
            if (this.foamed == 1) {
                this.foamColor = (byte)7;
                if (!duringLoad) {
                    IC2.network.get().updateTileEntityField(this, "foamColor");
                }
                IC2.addContinuousTickCallback(this.field_145850_b, new ITickCallback(){

                    @Override
                    public void tickCallback(World world) {
                        if (TileEntityCable.this.func_145837_r() || TileEntityCable.this.foamed != 1 || ((TileEntityCable)TileEntityCable.this).field_145850_b.field_73012_v.nextInt(500) == 0 && TileEntityCable.this.field_145850_b.func_72957_l(TileEntityCable.this.field_145851_c, TileEntityCable.this.field_145848_d, TileEntityCable.this.field_145849_e) * 6 >= ((TileEntityCable)TileEntityCable.this).field_145850_b.field_73012_v.nextInt(1000)) {
                            TileEntityCable.this.changeFoam((byte)2);
                            IC2.removeContinuousTickCallback(world, this);
                        }
                    }
                });
            } else if (foamed == 2) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 13, 3);
                IC2.network.get().announceBlockUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (!duringLoad) {
                IC2.network.get().updateTileEntityField(this, "foamed");
            }
        }
        return true;
    }

    public void onBlockChange() {
        byte[] array = new byte[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = EnergyNet.instance.getNeighbor(this, dir);
            if (tile == null) continue;
            array[dir.ordinal()] = (byte)(this.canInteractWith(tile, dir) ? 1 : 0);
        }
        if (!Util.match(this.connections, array)) {
            this.connections = array;
            IC2.network.get().updateTileEntityField(this, "connections");
        }
    }

    public boolean canConnect(int side) {
        return this.connections[side] == 1;
    }

    @Override
    public int getConductorColor() {
        return this.color;
    }
}

