/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagnetizer
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 100;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    public boolean upgraded = false;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
        this.upgraded = nbttagcompound.func_74767_n("Upgrade");
        if (this.upgraded) {
            this.upgradeMagnetizer();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", (short)this.energy);
        nbttagcompound.func_74757_a("Upgrade", this.upgraded);
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_145845_h() {
        int need;
        int y;
        super.func_145845_h();
        if (this.ticker-- > 0) {
            return;
        }
        boolean change = false;
        for (y = this.field_145848_d - 1; y > 0 && (this.upgraded || !this.upgraded && y >= this.field_145848_d - 20) && (this.upgraded && this.energy > 9 || !this.upgraded && this.energy > 0) && this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.ironFence.func_77973_b()); --y) {
            need = 15 - this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e);
            if (need <= 0) continue;
            if (this.upgraded) {
                need *= 10;
            }
            change = true;
            if (need > this.energy) {
                this.energy = need;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) + (this.upgraded ? need / 10 : need), 3);
            IC2.network.get().announceBlockUpdate(this.field_145850_b, this.field_145851_c, y, this.field_145849_e);
            this.energy -= need;
        }
        for (y = this.field_145848_d + 1; y < IC2.getWorldHeight(this.field_145850_b) && (this.upgraded || !this.upgraded && y <= this.field_145848_d + 20) && (this.upgraded && this.energy > 9 || !this.upgraded && this.energy > 0) && this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.ironFence.func_77973_b()); ++y) {
            need = 15 - this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e);
            if (need <= 0) continue;
            if (this.upgraded) {
                need *= 10;
            }
            change = true;
            if (need > this.energy) {
                this.energy = need;
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e) + (this.upgraded ? need / 10 : need), 3);
            IC2.network.get().announceBlockUpdate(this.field_145850_b, this.field_145851_c, y, this.field_145849_e);
            this.energy -= need;
        }
        if (!change) {
            this.ticker = 10;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount, double volt) {
        if (amount > (double)this.maxInput) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    public void onRightClick(EntityPlayer player) {
        ItemStack stack;
        if (!this.field_145850_b.field_72995_K && !this.upgraded && (stack = player.func_71045_bC()) != null && stack.func_77969_a(Ic2Items.overclockerUpgrade)) {
            --stack.field_77994_a;
            this.upgradeMagnetizer();
            player.field_71069_bz.func_75142_b();
        }
    }

    private void upgradeMagnetizer() {
        this.upgraded = true;
        this.maxEnergy = 1000;
        this.maxInput = 128;
    }

    @Override
    public void onBlockBreak(Block a, int b) {
        super.onBlockBreak(a, b);
        if (this.upgraded) {
            StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Ic2Items.overclockerUpgrade.func_77946_l());
        }
    }

    @Override
    public int getSinkTier() {
        return EnergyNet.instance.getTierFromPower(this.maxInput);
    }
}

