/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.crop.CropCardBase;
import ic2.core.block.crop.IC2Crops;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropNetherWart
extends CropCardBase {
    @Override
    public String name() {
        return "NetherWart";
    }

    @Override
    public String discoveredBy() {
        return "Notch";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Red", "Nether", "Ingredient", "Soulsand"};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        return Ic2Icons.getTexture("bc")[crop.getSize() + 36];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 3;
    }

    @Override
    public float dropGainChance() {
        return 2.0f;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151075_bm, 1);
    }

    @Override
    public void tick(ICropTile crop) {
        TileEntityCrop te = (TileEntityCrop)crop;
        if (te.isBlockBelow(Blocks.field_150425_aM)) {
            if (this.canGrow(te)) {
                TileEntityCrop tmp24_23 = te;
                tmp24_23.growthPoints += (int)((double)te.calcGrowthRate() * 0.5);
            }
        } else if (te.isBlockBelow(Blocks.field_150433_aE) && crop.getWorld().field_73012_v.nextInt(300) == 0) {
            te.setID((short)IC2Crops.cropTerraWart.getId());
        }
    }

    @Override
    public int maxSize() {
        return 3;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

