/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropColorFlower
extends CropCardBase {
    public String name;
    public String[] attributes;
    public int sprite;
    public int color;

    public CropColorFlower(String n, String[] a, int s, int c) {
        this.name = n;
        this.attributes = a;
        this.sprite = s;
        this.color = c;
    }

    @Override
    public String discoveredBy() {
        if (this.name().equals("Dandelion") || this.name().equals("Rose")) {
            return "Notch";
        }
        return "Alblaka";
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return this.attributes;
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        switch (crop.getSize()) {
            case 1: {
                return Ic2Icons.getTexture("bc")[12];
            }
            case 2: {
                return Ic2Icons.getTexture("bc")[13];
            }
            case 3: {
                return Ic2Icons.getTexture("bc")[14];
            }
            case 4: {
                return Ic2Icons.getTexture("bc")[this.sprite];
            }
        }
        return Ic2Icons.getTexture("bc")[0];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() <= 3 && crop.getLightLevel() >= 12;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151100_aR, 1, this.color);
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 3;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (crop.getSize() == 3) {
            return 600;
        }
        return 400;
    }

    @Override
    public int maxSize() {
        return 4;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

