/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.Ic2Icons;
import ic2.core.IconLoader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SubIconHandler {
    private static Map<String, BufferedImage> sheetCache = new HashMap<String, BufferedImage>();

    public static IIcon getSubIcon(IIconRegister r, String sheet, int pos) {
        String name = sheet + "!" + pos;
        if (!(r instanceof TextureMap)) {
            return r.func_94245_a(name);
        }
        SubIcon icon = new SubIcon(name, sheet, pos);
        ((TextureMap)r).setTextureEntry(name, (TextureAtlasSprite)icon);
        return icon;
    }

    public static IIcon getOverrideIcon(IIconRegister r, File file) {
        if (!(r instanceof TextureMap)) {
            return r.func_94245_a(file.getName());
        }
        OverrideIcon icon = new OverrideIcon(file);
        ((TextureMap)r).setTextureEntry(file.getName(), (TextureAtlasSprite)icon);
        return icon;
    }

    private static BufferedImage loadSheet(IResourceManager manager, String sheet) throws Exception {
        try {
            InputStream stream = manager.func_110536_a(new ResourceLocation("ic2", "textures" + sheet)).func_110527_b();
            if (stream == null) {
                throw new RuntimeException("Sheet not found: " + sheet);
            }
            return ImageIO.read(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class OverrideIcon
    extends TextureAtlasSprite {
        File file;

        public OverrideIcon(File par1) {
            super(par1.getName());
            this.file = par1;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            try {
                BufferedImage sheet = ImageIO.read(this.file);
                this.field_130223_c = sheet.getWidth();
                this.field_130224_d = sheet.getHeight();
                int[] data = new int[this.field_130223_c * this.field_130224_d];
                sheet.getRGB(0, 0, this.field_130223_c, this.field_130224_d, data, 0, this.field_130223_c);
                int[][] mipmaps = new int[FMLClientHandler.instance().getClient().field_71474_y.field_151442_I + 1][];
                mipmaps[0] = data;
                this.field_110976_a.add(mipmaps);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                FMLCommonHandler.instance().exitJava(0, false);
                return true;
            }
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }
    }

    public static class SubIcon
    extends TextureAtlasSprite {
        public String sheetName;
        public int pos;

        public SubIcon(String name, String sheet, int pos) {
            super(name);
            this.sheetName = sheet;
            this.pos = pos;
        }

        public boolean load(IResourceManager manager, ResourceLocation location) {
            try {
                BufferedImage sheet = (BufferedImage)sheetCache.get(this.sheetName);
                if (sheet == null) {
                    sheet = SubIconHandler.loadSheet(manager, this.sheetName);
                    sheetCache.put(this.sheetName, sheet);
                }
                this.field_130223_c = sheet.getWidth() / 16;
                this.field_130224_d = sheet.getHeight() / 16;
                int x = this.pos % 16 * this.field_130223_c;
                int y = this.pos / 16 * this.field_130224_d;
                int[] data = new int[this.field_130223_c * this.field_130224_d];
                sheet.getRGB(x, y, this.field_130223_c, this.field_130224_d, data, 0, this.field_130223_c);
                int[][] mipmaps = new int[FMLClientHandler.instance().getClient().field_71474_y.field_151442_I + 1][];
                mipmaps[0] = data;
                this.field_110976_a.add(mipmaps);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                FMLCommonHandler.instance().exitJava(0, false);
                return true;
            }
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }
    }

    public static class ForgeEventHandler {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchPost(TextureStitchEvent.Post evt) {
            sheetCache.clear();
            if (Boolean.getBoolean("ic2.debug.dumptex")) {
                int texid = evt.map.func_110552_b();
                GL11.glBindTexture((int)3553, (int)texid);
                FloatBuffer fb = BufferUtils.createFloatBuffer((int)6);
                fb.position(0).limit(6);
                GL11.glGetTexLevelParameter((int)3553, (int)0, (int)4096, (FloatBuffer)fb);
                fb.position(1).limit(6);
                GL11.glGetTexLevelParameter((int)3553, (int)0, (int)4097, (FloatBuffer)fb);
                int width = (int)fb.get(0);
                int height = (int)fb.get(1);
                System.out.println("Texture map " + evt.map.func_130086_a() + ": " + width + "x" + height);
                ByteBuffer pixels = ByteBuffer.allocateDirect(4 * width * height);
                pixels.position(0).limit(4 * width * height);
                GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)pixels);
                BufferedImage im = new BufferedImage(width, height, 2);
                int[] pixels_ar = new int[width * height];
                pixels.position(0).limit(4 * width * height);
                pixels.asIntBuffer().get(pixels_ar);
                for (int k = width * height - 1; k >= 0; --k) {
                    pixels_ar[k] = pixels_ar[k] >> 8 & 0xFFFFFF | pixels_ar[k] << 24;
                }
                im.setRGB(0, 0, width, height, pixels_ar, 0, width);
                try {
                    ImageIO.write((RenderedImage)im, "png", new File("debug.texture" + evt.map.func_130086_a() + ".png"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchPre(TextureStitchEvent.Pre evt) {
            Ic2Icons.load(evt.map);
            IconLoader.load(evt.map);
        }
    }
}

