/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.Loader;
import java.util.Arrays;
import java.util.Collections;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.powermodule.armor.ApiaristArmorModule;
import net.machinemuse.powersuits.powermodule.armor.HazmatModule;
import net.machinemuse.powersuits.powermodule.misc.AirtightSealModule;
import net.machinemuse.powersuits.powermodule.misc.ThaumGogglesModule;
import net.machinemuse.powersuits.powermodule.tool.AppEngWirelessFluidModule;
import net.machinemuse.powersuits.powermodule.tool.AppEngWirelessModule;
import net.machinemuse.powersuits.powermodule.tool.ChiselModule;
import net.machinemuse.powersuits.powermodule.tool.GrafterModule;
import net.machinemuse.powersuits.powermodule.tool.OmniProbeModule;
import net.machinemuse.powersuits.powermodule.tool.PersonalShrinkingModule;
import net.machinemuse.powersuits.powermodule.tool.ScoopModule;

public class ModCompatibility {
    public static double appengMultiplier;

    public static boolean isGregTechLoaded() {
        return Loader.isModLoaded((String)"gregtech_addon");
    }

    public static boolean isIndustrialCraftLoaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static boolean isThaumCraftLoaded() {
        return Loader.isModLoaded((String)"Thaumcraft");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }

    public static boolean isGalacticraftLoaded() {
        return Loader.isModLoaded((String)"GalacticraftCore");
    }

    public static boolean isCoFHCoreLoaded() {
        return Loader.isModLoaded((String)"CoFHCore");
    }

    public static boolean isForestryLoaded() {
        return Loader.isModLoaded((String)"Forestry");
    }

    public static boolean isChiselLoaded() {
        return Loader.isModLoaded((String)"chisel");
    }

    public static boolean isEnderIOLoaded() {
        return Loader.isModLoaded((String)"EnderIO");
    }

    public static boolean isAppengLoaded() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    public static boolean isExtraCellsLoaded() {
        return Loader.isModLoaded((String)"extracells");
    }

    public static boolean isMFRLoaded() {
        return Loader.isModLoaded((String)"MineFactoryReloaded");
    }

    public static boolean isRailcraftLoaded() {
        return Loader.isModLoaded((String)"Railcraft");
    }

    public static boolean isCompactMachinesLoaded() {
        return Loader.isModLoaded((String)"CompactMachines");
    }

    public static boolean enableThaumGogglesModule() {
        boolean defaultval = ModCompatibility.isThaumCraftLoaded();
        return Config.getConfig().get("Special Modules", "Thaumcraft Goggles Module", defaultval).getBoolean(defaultval);
    }

    public static double getIC2Ratio() {
        return Config.getConfig().get("general", "Energy per IC2 EU", 0.4).getDouble(0.4);
    }

    public static double getRFRatio() {
        return Config.getConfig().get("general", "Energy per RF", 0.1).getDouble(0.1);
    }

    public static void registerModSpecificModules() {
        ModCompatibility.getIC2Ratio();
        ModCompatibility.getRFRatio();
        if (ModCompatibility.isThaumCraftLoaded() && ModCompatibility.enableThaumGogglesModule()) {
            ModuleManager.addModule(new ThaumGogglesModule(Collections.singletonList(MPSItems.powerArmorHead())));
        }
        if (ModCompatibility.isIndustrialCraftLoaded()) {
            ModuleManager.addModule(new HazmatModule(Arrays.asList(MPSItems.powerArmorHead(), MPSItems.powerArmorTorso(), MPSItems.powerArmorLegs(), MPSItems.powerArmorFeet())));
        }
        if (ModCompatibility.isGalacticraftLoaded()) {
            ModuleManager.addModule(new AirtightSealModule(Collections.singletonList(MPSItems.powerArmorHead())));
        }
        if (ModCompatibility.isForestryLoaded()) {
            ModuleManager.addModule(new GrafterModule(Collections.singletonList(MPSItems.powerTool())));
            ModuleManager.addModule(new ScoopModule(Collections.singletonList(MPSItems.powerTool())));
            ModuleManager.addModule(new ApiaristArmorModule(Arrays.asList(MPSItems.powerArmorHead(), MPSItems.powerArmorTorso(), MPSItems.powerArmorLegs(), MPSItems.powerArmorFeet())));
        }
        if (ModCompatibility.isChiselLoaded()) {
            try {
                ModuleManager.addModule(new ChiselModule(Collections.singletonList(MPSItems.powerTool())));
            }
            catch (Exception e) {
                MuseLogger.logException((String)"Couldn't add Chisel module", (Throwable)e);
            }
        }
        if (ModCompatibility.isAppengLoaded()) {
            appengMultiplier = Config.getConfig().get("general", "Energy per AE", 5.0).getDouble(5.0);
            ModuleManager.addModule(new AppEngWirelessModule(Collections.singletonList(MPSItems.powerTool())));
            if (ModCompatibility.isExtraCellsLoaded()) {
                ModuleManager.addModule(new AppEngWirelessFluidModule(Collections.singletonList(MPSItems.powerTool())));
            }
        }
        if (ModCompatibility.isEnderIOLoaded() || ModCompatibility.isMFRLoaded() || ModCompatibility.isRailcraftLoaded()) {
            ModuleManager.addModule(new OmniProbeModule(Collections.singletonList(MPSItems.powerTool())));
        }
        if (ModCompatibility.isCompactMachinesLoaded()) {
            ModuleManager.addModule(new PersonalShrinkingModule(Collections.singletonList(MPSItems.powerTool())));
        }
    }
}

