/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurbineMeter
extends TileEntityReactorBase {
    private int turbineY = -1;
    private int oldlvl;
    private int lvl;

    @Override
    public int getIndex() {
        return ReactorTiles.TURBINEMETER.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntityTurbineCore te;
        if (this.getTicksExisted() == 0 || world.func_82737_E() % 32L == 0L) {
            this.remapTurbine(world, x, y, z);
        }
        int n = this.lvl = (te = this.getTurbine()) != null ? this.getRedstoneFrom(te) : 0;
        if (this.getTicksExisted() == 0 || this.oldlvl != this.lvl) {
            ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        }
        this.oldlvl = this.lvl;
    }

    private void remapTurbine(World world, int x, int y, int z) {
        for (int i = y + 1; i < world.field_73011_w.getHeight(); ++i) {
            ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, i, z);
            if (r != null && r.isTurbine()) {
                this.turbineY = i;
                return;
            }
            Block b = world.func_147439_a(x, i, z);
            if (b == Blocks.field_150350_a || b.getLightOpacity((IBlockAccess)world, x, i, z) <= 0) continue;
            this.turbineY = -1;
            return;
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRedstoneOverride() {
        return this.lvl;
    }

    private int getRedstoneFrom(TileEntityTurbineCore te) {
        int max = te.getMaxSpeed();
        return 15 * te.getOmega() / max;
    }

    public float getAnalogValue() {
        TileEntityTurbineCore te = this.getTurbine();
        return te != null ? (float)te.getOmega() / (float)te.getMaxSpeed() : 0.0f;
    }

    private TileEntityTurbineCore getTurbine() {
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.field_145851_c, this.turbineY, this.field_145849_e);
        if (r == null || !r.isTurbine()) {
            return null;
        }
        return (TileEntityTurbineCore)this.getTileEntity(this.field_145851_c, this.turbineY, this.field_145849_e);
    }

    @Override
    public int getTextureState(ForgeDirection side) {
        return side == ForgeDirection.UP ? 2 : (side == ForgeDirection.DOWN ? 0 : 1);
    }
}

