/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.SodiumSolarUpgrades;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.TileEntities.Production.TileEntitySolar;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarTop
extends TileEntityReactorBase
implements TemperatureTE,
SodiumSolarUpgrades.SodiumSolarReceiver {
    public static final int MAXTEMP = 1800;
    private final StepTimer tempTimer = new StepTimer(5);

    public boolean isActive() {
        return ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == this.getMachine() && this.getAdjacentTileEntity(ForgeDirection.DOWN) instanceof TileEntitySolar;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.SOLARTOP.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int Tamb;
        int dT;
        if (this.isActive() && !world.field_72995_K && this.getTicksExisted() % 8 == 0 && (dT = (Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)) - this.temperature) != 0) {
            int d = 16;
            int diff = 1 + dT / d;
            if (Math.abs(diff) <= 1) {
                diff = dT / Math.abs(dT);
            }
            this.temperature += diff;
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int getTemperature() {
        if (this.isActive()) {
            return this.temperature;
        }
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (te instanceof TileEntitySolarTop) {
            return ((TileEntitySolarTop)te).getTemperature();
        }
        return ReikaWorldHelper.getAmbientTemperatureAt((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    public int getMaxTemperature() {
        return 1800;
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
    }

    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    public int getThermalDamage() {
        return 10;
    }

    public void overheat(World world, int x, int y, int z) {
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
        world.func_147449_b(x, y, z, Blocks.field_150353_l);
    }

    public boolean canBeCooledWithFins() {
        return false;
    }

    public boolean allowExternalHeating() {
        return false;
    }

    public void tick(int mirrorCount, float totalBrightness) {
        if (!this.field_145850_b.field_72995_K) {
            this.temperature = (int)((double)this.temperature + 0.125 * (double)mirrorCount * (double)totalBrightness);
            this.temperature = Math.min(this.temperature, 1800);
        }
    }
}

