/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Base.BlockMultiBlock;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityHiPTurbine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityReactorFlywheel
extends TileEntityReactorBase
implements ShaftPowerEmitter,
Screwdriverable,
MultiBlockTile {
    private int iotick;
    private long power;
    private int omega;
    private int torque;
    private ForgeDirection facing;
    private boolean hasMultiBlock = false;
    private static final int MAXTORQUE = 12750;
    private static final int MAXTORQUE_AMMONIA = 25500;

    @Override
    public boolean hasMultiBlock() {
        return this.hasMultiBlock;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        this.hasMultiBlock = has;
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.FLYWHEEL.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.facing = this.setFacing(meta);
        int dx = x + this.getFacing().offsetX;
        int dy = y + this.getFacing().offsetY;
        int dz = z + this.getFacing().offsetZ;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
        if (r != null && r.isTurbine()) {
            TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(dx, dy, dz);
            this.omega = te.getOmega();
            this.torque = TileEntityReactorFlywheel.clampTorque(te);
        } else if (this.omega > 0) {
            this.omega -= this.omega / 32 + 1;
        }
        if (this.omega <= 0) {
            this.torque = 0;
            this.omega = 0;
        }
        this.power = (long)this.omega * (long)this.torque;
        TileEntity tg = this.getAdjacentTileEntity(this.getFacing().getOpposite());
        if (tg instanceof ShaftPowerReceiver) {
            ShaftPowerReceiver rec = (ShaftPowerReceiver)tg;
            rec.setOmega(this.getOmega());
            rec.setTorque(this.getTorque());
            rec.setPower(this.getPower());
        }
    }

    public static int clampTorque(TileEntityTurbineCore te) {
        return te instanceof TileEntityHiPTurbine ? te.getTorque() : Math.min(te.getTorque(), te.isAmmonia() ? 25500 : 12750);
    }

    private ForgeDirection setFacing(int meta) {
        switch (meta) {
            case 0: {
                return ForgeDirection.EAST;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.NORTH;
            }
        }
        return null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        int dx = x + this.getFacing().offsetX;
        int dy = y + this.getFacing().offsetY;
        int dz = z + this.getFacing().offsetZ;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
        if (r != null && r.isTurbine()) {
            TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(dx, dy, dz);
            this.phi = te.phi * 6.0f;
        }
        this.iotick -= 8;
    }

    public int getOmega() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return this.power;
    }

    public int getIORenderAlpha() {
        return this.iotick;
    }

    public void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    public long getMaxPower() {
        return Long.MAX_VALUE;
    }

    public long getCurrentPower() {
        return this.power;
    }

    public boolean canWriteTo(ForgeDirection from) {
        ForgeDirection dir = this.getFacing().getOpposite();
        return dir == from;
    }

    public boolean isEmitting() {
        return this.hasMultiBlock();
    }

    public int getEmittingX() {
        return this.field_145851_c + this.getFacing().getOpposite().offsetX;
    }

    public int getEmittingY() {
        return this.field_145848_d + this.getFacing().getOpposite().offsetY;
    }

    public int getEmittingZ() {
        return this.field_145849_e + this.getFacing().getOpposite().offsetZ;
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        int meta = this.func_145832_p();
        if (this.hasMultiBlock()) {
            this.setBlockMetadata(meta - meta % 2 + (1 - meta % 2));
        } else if (meta < 3) {
            this.setBlockMetadata(meta + 1);
        } else {
            this.setBlockMetadata(0);
        }
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.facing = this.dirs[NBT.func_74762_e("face")];
        this.hasMultiBlock = NBT.func_74767_n("multi");
        this.power = NBT.func_74763_f("pwr");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74757_a("multi", this.hasMultiBlock);
        NBT.func_74772_a("pwr", this.power);
    }

    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dy = this.field_145848_d + dir.offsetY;
                int dz = this.field_145849_e + dir.offsetZ;
                Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
                if (!(b instanceof BlockMultiBlock)) continue;
                ((BlockMultiBlock)b).breakMultiBlock(this.field_145850_b, dx, dy, dz);
            }
        }
    }
}

