/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Interfaces.Shockable;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityElectrolyzer
extends TileEntityInventoriedReactorBase
implements IFluidHandler,
PipeConnector,
TemperatureTE,
ThermalMachine,
Shockable {
    public static final int SODIUM_MELT = 98;
    public static final int SALT_MELT = 801;
    public static final int CAPACITY = 6000;
    public static final int MAXTEMP = 1200;
    private final HybridTank tankL = new HybridTank("lighttank", this.getCapacity());
    private final HybridTank tankH = new HybridTank("heavytank", this.getCapacity());
    private final HybridTank input = new HybridTank("input", this.getCapacity() * 2);
    private StepTimer timer = new StepTimer(50);
    private StepTimer tempTimer = new StepTimer(20);
    public int time;
    private int temperature;
    private Electrolysis recipe;

    @Override
    public int getIndex() {
        return ReactorTiles.ELECTROLYZER.ordinal();
    }

    public int getCapacity() {
        return 6000;
    }

    public int getHLevel() {
        return this.tankH.getLevel();
    }

    public int getLLevel() {
        return this.tankL.getLevel();
    }

    public int getTime() {
        return this.timer.getTick();
    }

    public int getTimerScaled(int d) {
        return d * this.time / this.timer.getCap();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (this.recipe == null) {
            this.recipe = this.findRecipe();
        }
        if (!world.field_72995_K) {
            if (this.recipe != null && this.recipe.requirementsMet(this)) {
                if (this.timer.checkCap()) {
                    this.recipe.run(this);
                }
            } else {
                this.recipe = null;
                this.timer.reset();
            }
            this.time = this.timer.getTick();
        }
    }

    private Electrolysis findRecipe() {
        for (Electrolysis e : Electrolysis.recipes) {
            if (!e.requirementsMet(this)) continue;
            return e;
        }
        return null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY != 0 ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.input.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int maxDrain = resource.amount;
        if (from == ForgeDirection.DOWN && resource.getFluid() == this.tankH.getActualFluid()) {
            return this.tankH.drain(maxDrain, doDrain);
        }
        if (from == ForgeDirection.UP && resource.getFluid() == this.tankL.getActualFluid()) {
            return this.tankL.drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.DOWN) {
            return this.tankH.drain(maxDrain, doDrain);
        }
        if (from == ForgeDirection.UP) {
            return this.tankL.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.offsetY != 0) {
            return false;
        }
        for (Electrolysis e : Electrolysis.recipes) {
            if (!e.uses(fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY != 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tankH.getInfo(), this.tankL.getInfo(), this.input.getInfo()};
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        for (Electrolysis e : Electrolysis.recipes) {
            if (!e.uses(itemstack)) continue;
            return true;
        }
        return false;
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection lavaside;
        ForgeDirection fireside;
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (waterside != null) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        if ((fireside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab)) != null) {
            Tamb += 200;
        }
        if ((lavaside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i)) != null) {
            Tamb += 600;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1200) {
            this.temperature = 1200;
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getThermalDamage() {
        return 0;
    }

    public void overheat(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
    }

    public void onDischarge(int charge, double range) {
        if (this.recipe != null) {
            int n;
            int extra = charge - this.getMinDischarge();
            int n2 = n = extra > 0 ? (int)Math.sqrt(extra) / 16 : 1;
            if (n == 0) {
                n = 1;
            }
            for (int i = 0; i < n; ++i) {
                this.timer.update();
            }
        }
    }

    public int getMinDischarge() {
        return 4096;
    }

    public void setTemperature(int T) {
        this.temperature = T;
    }

    public int getMaxTemperature() {
        return 1200;
    }

    public void onOverheat(World world, int x, int y, int z) {
    }

    public boolean canBeFrictionHeated() {
        return true;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tankH.writeToNBT(NBT);
        this.tankL.writeToNBT(NBT);
        this.input.writeToNBT(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tankH.readFromNBT(NBT);
        this.tankL.readFromNBT(NBT);
        this.input.readFromNBT(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    public boolean addHeavyWater(int amt) {
        if (this.input.canTakeIn(amt)) {
            this.input.addLiquid(amt, FluidRegistry.getFluid((String)"rc heavy water"));
            return true;
        }
        return false;
    }

    @Override
    public boolean canEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean canExitToSide(ForgeDirection dir) {
        return false;
    }

    public float getAimX() {
        return 0.5f;
    }

    public float getAimY() {
        return 0.9375f;
    }

    public float getAimZ() {
        return 0.5f;
    }

    public int getInputLevel() {
        return this.input.getLevel();
    }

    public boolean canBeCooledWithFins() {
        return false;
    }

    public boolean allowExternalHeating() {
        return true;
    }

    public boolean canDischargeLongRange() {
        return false;
    }

    public float getMultiplier() {
        return 0.5f;
    }

    public void resetAmbientTemperatureTimer() {
        this.tempTimer.reset();
    }

    public static void addRecipe(String name, Fluid in, int amt, ItemMatch item, boolean cata, Fluid out1, int amt1, Fluid out2, int amt2, int temp) {
        Class[] types = new Class[]{Fluid.class, Integer.TYPE, ItemMatch.class, Boolean.TYPE, Fluid.class, Integer.TYPE, Fluid.class, Integer.TYPE, Integer.TYPE};
        Object[] args = new Object[]{in, amt, item, cata, out1, amt1, out2, amt2, temp};
        Electrolysis c = (Electrolysis)EnumHelper.addEnum(Electrolysis.class, (String)name.toUpperCase(), (Class[])types, (Object[])args);
        Electrolysis.access$102(Electrolysis.values());
    }

    public static enum Electrolysis {
        SALT(new ItemMatch("salt/dustSalt").addItem(new KeyedItemStack(ItemStacks.salt)), false, FluidRegistry.getFluid((String)"rc chlorine"), 100, FluidRegistry.getFluid((String)"rc sodium"), 100, 801),
        HEAVYWATER(FluidRegistry.getFluid((String)"rc heavy water"), 100, null, false, FluidRegistry.getFluid((String)"rc deuterium"), 100, FluidRegistry.getFluid((String)"rc oxygen"), 50);

        public final FluidStack requiredFluid;
        private final ItemMatch requiredItem;
        public final boolean consumeItem;
        public final FluidStack upperOutput;
        public final FluidStack lowerOutput;
        public final int requiredTemperature;
        private static Electrolysis[] recipes;

        private Electrolysis(ItemMatch item, boolean cata, Fluid out1, int amt1, Fluid out2, int amt2) {
            this(null, 0, item, cata, out1, amt1, out2, amt2, 0);
        }

        private Electrolysis(ItemMatch item, boolean cata, Fluid out1, int amt1, Fluid out2, int amt2, int temp) {
            this(null, 0, item, cata, out1, amt1, out2, amt2, temp);
        }

        private Electrolysis(Fluid in, int amt, ItemMatch item, boolean cata, Fluid out1, int amt1, Fluid out2, int amt2) {
            this(in, amt, item, cata, out1, amt1, out2, amt2, 0);
        }

        private Electrolysis(Fluid in, int amt, ItemMatch item, boolean cata, Fluid out1, int amt1, Fluid out2, int amt2, int temp) {
            this.requiredFluid = in != null ? new FluidStack(in, amt) : null;
            this.requiredItem = item != null ? item.copy() : null;
            this.consumeItem = !cata;
            this.upperOutput = out1 != null ? new FluidStack(out1, amt1) : null;
            this.lowerOutput = out2 != null ? new FluidStack(out2, amt2) : null;
            this.requiredTemperature = temp;
        }

        public boolean requirementsMet(TileEntityElectrolyzer te) {
            if (this.requiredFluid != null && (te.input.getActualFluid() != this.requiredFluid.getFluid() || te.input.getLevel() < this.requiredFluid.amount)) {
                return false;
            }
            if (!(this.requiredItem == null || te.inv[0] != null && this.requiredItem.match(te.inv[0]))) {
                return false;
            }
            if (this.upperOutput != null && (te.tankL.isFull() || !te.tankL.isEmpty() && te.tankL.getActualFluid() != this.upperOutput.getFluid())) {
                return false;
            }
            if (this.lowerOutput != null && (te.tankH.isFull() || !te.tankH.isEmpty() && te.tankH.getActualFluid() != this.lowerOutput.getFluid())) {
                return false;
            }
            return te.temperature >= this.requiredTemperature;
        }

        private void run(TileEntityElectrolyzer te) {
            if (this.requiredFluid != null) {
                te.input.removeLiquid(this.requiredFluid.amount);
            }
            if (this.requiredItem != null && this.consumeItem) {
                ReikaInventoryHelper.decrStack((int)0, (ItemStack[])te.inv);
            }
            if (this.upperOutput != null) {
                te.tankL.addLiquid(this.upperOutput.amount, this.upperOutput.getFluid());
            }
            if (this.lowerOutput != null) {
                te.tankH.addLiquid(this.lowerOutput.amount, this.lowerOutput.getFluid());
            }
        }

        public boolean makes(Fluid f) {
            return this.upperOutput != null && this.upperOutput.getFluid() == f || this.lowerOutput != null && this.lowerOutput.getFluid() == f;
        }

        public boolean uses(Fluid f) {
            return this.requiredFluid != null && this.requiredFluid.getFluid() == f;
        }

        public boolean uses(ItemStack is) {
            return this.requiredItem != null && this.requiredItem.match(is);
        }

        public static Electrolysis[] getRecipes() {
            return Arrays.copyOf(recipes, recipes.length);
        }

        public boolean hasItemRequirement() {
            return this.requiredItem != null;
        }

        public Collection<ItemStack> getItemListForDisplay() {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            for (KeyedItemStack ks : this.requiredItem.getItemList()) {
                ret.add(ks.getItemStack());
            }
            return ret;
        }

        static /* synthetic */ Electrolysis[] access$102(Electrolysis[] x0) {
            recipes = x0;
            return x0;
        }

        static {
            recipes = Electrolysis.values();
        }
    }
}

