/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.HTGR;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.Feedable;
import Reika.ReactorCraft.Auxiliary.PebbleBedArrangement;
import Reika.ReactorCraft.Auxiliary.ReactorBlock;
import Reika.ReactorCraft.Auxiliary.Temperatured;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPebbleBed
extends TileEntityInventoriedReactorBase
implements Temperatured,
Feedable,
ReactorBlock,
BreakAction {
    protected StepTimer tempTimer = new StepTimer(20);
    private PebbleBedArrangement reactor;
    public static final int MINTEMP = 800;
    public static final int OVERTEMP = 1200;
    public static final int FAILTEMP = 4400;
    private int damage = 0;
    private int cycleCooldown = 0;

    public int func_70302_i_() {
        return 47;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.isFissile() && ReikaRandomHelper.doWithChance((double)(this.getFissionChance() / 100.0))) {
            this.runDecayCycle();
        }
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.clearInventory((IInventory)this);
            ReikaInventoryHelper.addToIInv((ItemStack)ReactorItems.PELLET.getStackOf(), (IInventory)this);
        }
        if (!world.field_72995_K) {
            this.feed();
        }
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z);
        }
        if (this.damage > 0 && rand.nextInt(800) == 0) {
            --this.damage;
        }
        if (this.cycleCooldown > 0) {
            --this.cycleCooldown;
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.checkAndJoinArrangement(world, x, y, z);
    }

    private void checkAndJoinArrangement(World world, int x, int y, int z) {
        this.reactor = new PebbleBedArrangement(this);
        int r = 3;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    TileEntity te = this.getTileEntity(dx, dy, dz);
                    if (!(te instanceof TileEntityPebbleBed)) continue;
                    this.reactor.merge(((TileEntityPebbleBed)te).reactor);
                }
            }
        }
    }

    private double getFissionChance() {
        int size = this.getReactorSize();
        if (size >= 128) {
            return 1.0;
        }
        if (size >= 72) {
            return 2.0;
        }
        if (size >= 48) {
            return 3.0;
        }
        if (size >= 36) {
            return 4.0;
        }
        if (size >= 24) {
            return 6.0;
        }
        if (size >= 12) {
            return 4.0;
        }
        if (size >= 6) {
            return 2.0;
        }
        return 1.0;
    }

    private int getReactorSize() {
        return this.reactor.getSize();
    }

    public void setReactorObject(PebbleBedArrangement pba) {
        this.reactor = pba;
    }

    public void breakBlock() {
        this.reactor.remove(this);
    }

    private void runDecayCycle() {
        if (!this.field_145850_b.field_72995_K) {
            int slot = -1;
            for (int i = this.inv.length - 1; i >= 0; --i) {
                ItemStack is = this.inv[i];
                if (is == null || is.func_77973_b() != ReactorItems.PELLET.getItemInstance()) continue;
                slot = i;
                i = -1;
            }
            if (slot != -1) {
                if (ReikaRandomHelper.doWithChance((double)3.0)) {
                    ItemStack is = this.inv[slot];
                    this.inv[slot] = this.getFissionProduct(is);
                }
                this.temperature += 20;
            }
        }
    }

    private ItemStack getFissionProduct(ItemStack is) {
        if (is.func_77960_j() == ReactorItems.PELLET.getNumberMetadatas() - 1) {
            return ReactorItems.OLDPELLET.getStackOf();
        }
        return ReactorItems.PELLET.getStackOfMetadata(is.func_77960_j() + 1);
    }

    @Override
    protected void updateTemperature(World world, int x, int y, int z) {
        int chance;
        super.updateTemperature(world, x, y, z);
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = this.temperature - Tamb;
        if (dT != 0) {
            int f = ReikaWorldHelper.isExposedToAir((World)world, (int)x, (int)y, (int)z) ? 32 : 96;
            this.temperature -= 1 + dT / f;
        }
        if (dT > 0) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
                if (r != this.getMachine()) continue;
                TileEntityPebbleBed te = (TileEntityPebbleBed)world.func_147438_o(dx, dy, dz);
                int dTemp = this.temperature - te.temperature;
                if (dTemp <= 0) continue;
                this.temperature -= dTemp / 16;
                te.temperature += dTemp / 16;
            }
        }
        if (this.temperature >= this.getMaxTemperature()) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
        } else if (this.temperature >= 1200 && rand.nextInt(chance = 5 + (4400 - this.temperature) / 10 / this.getReactorSize()) == 0) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)1.0f, (float)0.5f);
            ReikaParticleHelper.SMOKE.spawnAroundBlockWithOutset(world, x, y, z, 9, 0.0625);
            ++this.damage;
            if (this.damage >= 100) {
                this.melt(world, x, y, z);
            }
        }
    }

    private void melt(World world, int x, int y, int z) {
        ReactorAchievements.PEBBLEFAIL.triggerAchievement(this.getPlacer());
        this.delete();
        world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz", (float)2.0f, (float)0.1f);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)1.0f, (float)0.2f);
        ReikaParticleHelper.LAVA.spawnAroundBlockWithOutset(world, x, y, z, 12, 0.0625);
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return is.func_77973_b() == ReactorItems.PELLET.getItemInstance() || is.func_77973_b() == ReactorItems.OLDPELLET.getItemInstance();
    }

    @Override
    public boolean canEnterFromSide(ForgeDirection dir) {
        return dir == ForgeDirection.UP;
    }

    @Override
    public boolean canExitToSide(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    @Override
    public boolean canRemoveItem(int slot, ItemStack is) {
        if (is.func_77973_b() == ReactorItems.OLDPELLET.getItemInstance()) {
            return true;
        }
        if (slot == 0 && this.cycleCooldown == 0 && this.getTileEntityAge() % 80L < 40L) {
            this.cycleCooldown = 10;
            return true;
        }
        return false;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.PEBBLEBED.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean isFissile() {
        return ReikaInventoryHelper.checkForItem((Item)ReactorItems.PELLET.getItemInstance(), (ItemStack[])this.inv);
    }

    @Override
    public boolean feed() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block id = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof TileEntityPebbleBed && ((Feedable)tile).feedIn(this.inv[this.inv.length - 1])) {
            for (int i = this.inv.length - 1; i > 0; --i) {
                this.inv[i] = this.inv[i - 1];
            }
            id = world.func_147439_a(x, y + 1, z);
            meta = world.func_72805_g(x, y + 1, z);
            tile = this.getAdjacentTileEntity(ForgeDirection.UP);
            this.inv[0] = tile instanceof TileEntityPebbleBed ? ((Feedable)tile).feedOut() : null;
        }
        this.collapseInventory();
        return false;
    }

    private void collapseInventory() {
        for (int i = 0; i < this.inv.length; ++i) {
            for (int k = this.inv.length - 1; k > 0; --k) {
                if (this.inv[k] != null) continue;
                this.inv[k] = this.inv[k - 1];
                this.inv[k - 1] = null;
            }
        }
    }

    @Override
    public boolean feedIn(ItemStack is) {
        if (is == null) {
            return true;
        }
        if (!this.func_94041_b(0, is)) {
            return false;
        }
        if (this.inv[0] == null) {
            this.inv[0] = is.func_77946_l();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack feedOut() {
        if (this.inv[this.inv.length - 1] == null) {
            return null;
        }
        ItemStack is = this.inv[this.inv.length - 1].func_77946_l();
        this.inv[this.inv.length - 1] = null;
        return is;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public int getMaxTemperature() {
        return 4400;
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return false;
    }

    @Override
    public final int getTextureState(ForgeDirection side) {
        if (side.offsetY != 0) {
            return 4;
        }
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles src = this.getMachine();
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        ReactorTiles r2 = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r2 == src && r == src) {
            return 2;
        }
        if (r2 == src) {
            return 1;
        }
        if (r == src) {
            return 3;
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.damage = NBT.func_74762_e("dmg");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("dmg", this.damage);
    }
}

